/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class ModelUtils {
    private final Elements elementUtils;
    private final Types typeUtils;

    protected ModelUtils(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public Stream<TypeElement> resolveTypeElements(Set<? extends Element> annotatedElements) {
        return annotatedElements.stream().flatMap(element -> {
            if (element instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)element;
                return Stream.of(executableElement.getEnclosingElement());
            }
            if (element instanceof VariableElement) {
                VariableElement variableElement = (VariableElement)element;
                return Stream.of(variableElement.getEnclosingElement());
            }
            if (element instanceof PackageElement) {
                PackageElement packageElement = (PackageElement)element;
                return packageElement.getEnclosedElements().stream();
            }
            return Stream.of(element);
        }).filter(element -> JavaModelUtils.isClassOrInterface((Element)element) || JavaModelUtils.isEnum((Element)element) || JavaModelUtils.isRecord((Element)element)).map(this::classElementFor).filter(Objects::nonNull).filter(element -> element.getAnnotation(Generated.class) == null);
    }

    @Nullable
    public final TypeElement classElementFor(Element element) {
        while (!(element == null || JavaModelUtils.isClassOrInterface((Element)element) || JavaModelUtils.isRecord((Element)element) || JavaModelUtils.isEnum((Element)element))) {
            element = element.getEnclosingElement();
        }
        if (element instanceof TypeElement) {
            TypeElement e = (TypeElement)element;
            return e;
        }
        return null;
    }

    String resolveTypeName(TypeMirror type) {
        TypeMirror typeMirror = this.resolveTypeReference(type);
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        if (typeElement != null) {
            return this.elementUtils.getBinaryName(typeElement).toString();
        }
        return this.typeUtils.erasure(typeMirror).toString();
    }

    TypeMirror resolveTypeReference(TypeMirror type) {
        TypeKind typeKind = type.getKind();
        if (typeKind.isPrimitive()) {
            return type;
        }
        if (typeKind == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            if (dt.getTypeArguments().isEmpty()) {
                return dt;
            }
            return this.typeUtils.erasure(type);
        }
        return this.typeUtils.erasure(type);
    }

    boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public Optional<ElementKind> resolveKind(Element element, ElementKind expected) {
        Optional<ElementKind> elementKind = this.resolveKind(element);
        if (elementKind.isPresent() && elementKind.get() == expected) {
            return elementKind;
        }
        return Optional.empty();
    }

    public Optional<ElementKind> resolveKind(Element element) {
        if (element != null) {
            try {
                ElementKind kind = element.getKind();
                return Optional.of(kind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

