/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public final class AssertionUtils {
    private AssertionUtils() {
    }

    public static BiConsumer<ServerUnderTest, HttpRequest<?>> assertThrowsStatus(@NonNull HttpStatus status) {
        return (server, request) -> AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(status).build());
    }

    public static void assertThrows(@NonNull ServerUnderTest server, @NonNull HttpRequest<?> request, @NonNull HttpResponseAssertion assertion) {
        Executable e = assertion.getBody() != null ? () -> server.exchange(request, Argument.of((Class)assertion.getBody().stream().map(BodyAssertion::getBodyType).findFirst().orElseThrow()), AssertionUtils.errorType(assertion)) : () -> server.exchange(request);
        HttpClientResponseException thrown = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, (Executable)e);
        HttpResponse response = thrown.getResponse();
        Assertions.assertEquals((Object)assertion.getHttpStatus(), (Object)response.getStatus());
        AssertionUtils.assertHeaders(response, assertion.getHeaders());
        AssertionUtils.assertBody(response, assertion.getBody());
        assertion.getResponseConsumer().ifPresent(httpResponseConsumer -> httpResponseConsumer.accept(response));
    }

    @Nullable
    private static Argument errorType(HttpResponseAssertion assertion) {
        if (assertion.getBody() == null) {
            return HttpClient.DEFAULT_ERROR_TYPE;
        }
        return assertion.getBody().stream().map(BodyAssertion::getErrorType).findFirst().map(Argument::of).orElseGet(() -> {
            Argument defaultErrorType = HttpClient.DEFAULT_ERROR_TYPE;
            return defaultErrorType;
        });
    }

    public static void assertThrows(@NonNull ServerUnderTest server, @NonNull HttpRequest<?> request, @NonNull HttpStatus expectedStatus, @Nullable String expectedBody, @Nullable Map<String, String> expectedHeaders) {
        AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(expectedStatus).body(expectedBody).headers(expectedHeaders).build());
    }

    public static <T> void assertDoesNotThrow(@NonNull ServerUnderTest server, @NonNull HttpRequest<T> request, @NonNull HttpStatus expectedStatus, @Nullable String expectedBody, @Nullable Map<String, String> expectedHeaders) {
        AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(expectedStatus).body(expectedBody).headers(expectedHeaders).build());
    }

    public static <T> void assertDoesNotThrow(@NonNull ServerUnderTest server, @NonNull HttpRequest<T> request, @NonNull HttpResponseAssertion assertion) {
        ThrowingSupplier executable = assertion.getBody() != null ? () -> server.exchange(request, Argument.of((Class)assertion.getBody().stream().map(BodyAssertion::getBodyType).findFirst().orElseThrow()), AssertionUtils.errorType(assertion)) : () -> server.exchange(request);
        HttpResponse response = (HttpResponse)Assertions.assertDoesNotThrow((ThrowingSupplier)executable);
        Assertions.assertEquals((Object)assertion.getHttpStatus(), (Object)response.getStatus());
        AssertionUtils.assertHeaders(response, assertion.getHeaders());
        AssertionUtils.assertBody(response, assertion.getBody());
        assertion.getResponseConsumer().ifPresent(httpResponseConsumer -> httpResponseConsumer.accept(response));
    }

    private static void assertBody(@NonNull HttpResponse<?> response, @Nullable List<BodyAssertion<?, ?>> bodyAssertions) {
        if (bodyAssertions != null) {
            for (BodyAssertion<?, ?> bodyAssertion : bodyAssertions) {
                Optional bodyOptional = response.getBody(bodyAssertion.getBodyType());
                bodyAssertion.evaluate(bodyOptional.orElse(null));
            }
        }
    }

    private static void assertHeaders(@NonNull HttpResponse<?> response, @Nullable Map<String, String> expectedHeaders) {
        if (expectedHeaders != null) {
            for (Map.Entry<String, String> expectedHeadersEntrySet : expectedHeaders.entrySet()) {
                String headerName = expectedHeadersEntrySet.getKey();
                Optional headerOptional = response.getHeaders().getFirst((CharSequence)headerName);
                Assertions.assertTrue((boolean)headerOptional.isPresent(), () -> "Header " + headerName + " not present");
                headerOptional.ifPresent(headerValue -> {
                    String expectedValue = (String)expectedHeadersEntrySet.getValue();
                    if (headerName.equals("Content-Type")) {
                        if (headerValue.contains(";charset=")) {
                            Assertions.assertTrue((boolean)headerValue.startsWith(expectedValue), () -> "header value " + headerValue + " does not start with " + expectedValue);
                        } else {
                            Assertions.assertEquals((Object)expectedValue, headerOptional.get());
                        }
                    } else {
                        Assertions.assertEquals((Object)expectedValue, headerOptional.get());
                    }
                });
            }
        }
    }
}

