/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadataImpl;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public interface ConnectionMetadata {
    public @NonNull Optional<SocketAddress> localAddress();

    public @NonNull Optional<SocketAddress> remoteAddress();

    public static Optional<String> getHostAddress(@NonNull SocketAddress a) {
        if (a instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)a;
            return Optional.of(addr.getAddress().getHostAddress());
        }
        return ConnectionMetadata.getHostName(a);
    }

    public static Optional<String> getHostName(@NonNull SocketAddress a) {
        if (a instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)a;
            return Optional.of(addr.getAddress().getHostName());
        }
        if (a instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress addr = (UnixDomainSocketAddress)a;
            return Optional.of(addr.getPath().toString()).filter(s -> !s.isEmpty());
        }
        if (ConnectionMetadataImpl.DOMAIN_SOCKET_ADDRESS.isInstance(a)) {
            Object path = ConnectionMetadataImpl.DomainSocketUtil.getPath(a);
            if (((String)path).isEmpty() || ((String)path).equals("\u0000")) {
                return Optional.empty();
            }
            if (((String)path).startsWith("\u0000")) {
                path = "@" + ((String)path).substring(1);
            }
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static @NonNull ConnectionMetadata ofNettyChannel(@NonNull Channel channel) {
        if (channel instanceof SocketChannel) {
            SocketChannel sc = (SocketChannel)channel;
            return new ConnectionMetadataImpl.SocketChannelMetadata(sc);
        }
        if (ConnectionMetadataImpl.QUIC_CHANNEL != null && ConnectionMetadataImpl.QUIC_CHANNEL.isInstance(channel)) {
            return new ConnectionMetadataImpl.QuicChannelMetadata(channel);
        }
        if (channel instanceof DatagramChannel || channel instanceof NioDomainSocketChannel || ConnectionMetadataImpl.DOMAIN_SOCKET_CHANNEL != null && ConnectionMetadataImpl.DOMAIN_SOCKET_CHANNEL.isInstance(channel)) {
            return new ConnectionMetadataImpl.GenericChannelMetadata(channel);
        }
        if (channel.parent() != null) {
            return ConnectionMetadata.ofNettyChannel(channel.parent());
        }
        return ConnectionMetadata.empty();
    }

    public static @NonNull ConnectionMetadata empty() {
        return ConnectionMetadataImpl.Empty.INSTANCE;
    }
}

