/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyBodyAnnotationBinder;
import io.micronaut.http.server.netty.binders.NettyPublisherBodyBinder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.jspecify.annotations.NonNull;

@Internal
final class NettyCompletableFutureBodyBinder
implements NonBlockingBodyArgumentBinder<CompletableFuture<?>> {
    private static final Argument<CompletableFuture<?>> TYPE = Argument.of(CompletableFuture.class);
    private final NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder;

    NettyCompletableFutureBodyBinder(NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder) {
        this.nettyBodyAnnotationBinder = nettyBodyAnnotationBinder;
    }

    public @NonNull List<Class<?>> superTypes() {
        return Arrays.asList(CompletionStage.class, Future.class);
    }

    public Argument<CompletableFuture<?>> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<CompletableFuture<?>> bind(ArgumentConversionContext<CompletableFuture<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody rootBody = nhr.byteBody();
            if (rootBody.expectedLength().orElse(-1L) == 0L) {
                return ArgumentBinder.BindingResult.empty();
            }
            Optional firstTypeParameter = context.getFirstTypeVariable();
            Argument targetType = firstTypeParameter.orElse(Argument.OBJECT_ARGUMENT);
            CompletableFuture future = InternalByteBody.bufferFlow((ByteBody)rootBody).map(bytes -> {
                Optional<Object> value;
                try {
                    value = this.nettyBodyAnnotationBinder.transform(nhr, (ArgumentConversionContext<Object>)context.with(targetType), (AvailableByteBody)bytes);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return value.orElseThrow(() -> NettyPublisherBodyBinder.extractError(null, context));
            }).toCompletableFuture();
            return () -> Optional.of(future);
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

