/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.ssl.NettyServerSslFactory;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ServerSocketChannel;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public interface NettyEmbeddedServices {
    public MessageBodyHandlerRegistry getMessageBodyHandlerRegistry();

    public @NonNull List<ChannelOutboundHandler> getOutboundHandlers();

    public @NonNull ApplicationContext getApplicationContext();

    default public @NonNull RequestArgumentSatisfier getRequestArgumentSatisfier() {
        return this.getRouteExecutor().getRequestArgumentSatisfier();
    }

    public @NonNull RouteExecutor getRouteExecutor();

    public @NonNull MediaTypeCodecRegistry getMediaTypeCodecRegistry();

    public @NonNull StaticResourceResolver getStaticResourceResolver();

    default public @NonNull ExecutorSelector getExecutorSelector() {
        return this.getRouteExecutor().getExecutorSelector();
    }

    public @Nullable ServerSslBuilder getServerSslBuilder();

    public @NonNull ChannelOptionFactory getChannelOptionFactory();

    public @NonNull HttpCompressionStrategy getHttpCompressionStrategy();

    public Optional<NettyServerWebSocketUpgradeHandler> getWebSocketUpgradeHandler(NettyEmbeddedServer var1);

    public @NonNull EventLoopGroupRegistry getEventLoopGroupRegistry();

    default public @NonNull Router getRouter() {
        return this.getRouteExecutor().getRouter();
    }

    public @NonNull EventLoopGroup createEventLoopGroup(@NonNull EventLoopGroupConfiguration var1);

    public @NonNull EventLoopGroup createEventLoopGroup(int var1, @NonNull ExecutorService var2, @Nullable Integer var3);

    @Deprecated(since="4.5.0", forRemoval=true)
    default public @NonNull ServerSocketChannel getServerSocketChannelInstance(@NonNull EventLoopGroupConfiguration workerConfig) {
        return (ServerSocketChannel)this.getChannelInstance(NettyChannelType.SERVER_SOCKET, workerConfig);
    }

    @Deprecated(since="4.5.0", forRemoval=true)
    default public @NonNull ServerChannel getDomainServerChannelInstance(@NonNull EventLoopGroupConfiguration workerConfig) {
        return (ServerChannel)this.getChannelInstance(NettyChannelType.DOMAIN_SERVER_SOCKET, workerConfig);
    }

    default public @NonNull Channel getChannelInstance(NettyChannelType type, @NonNull EventLoopGroupConfiguration workerConfig) {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> this.getServerSocketChannelInstance(workerConfig);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> this.getDomainServerChannelInstance(workerConfig);
            default -> throw new UnsupportedOperationException("Unsupported netty channel type");
        };
    }

    default public @NonNull Channel getChannelInstance(NettyChannelType type, @NonNull EventLoopGroupConfiguration workerConfig, Channel parent, int fd) {
        throw new UnsupportedOperationException("File descriptor channels not supported");
    }

    public <E> @NonNull ApplicationEventPublisher<E> getEventPublisher(@NonNull Class<E> var1);

    public NettyServerSslFactory getSslFactory();

    public @NonNull BeanProvider<CertificateProvider> getCertificateProviders();
}

