/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.netty.body.BodySizeLimits;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.handler.Compressor;
import io.micronaut.http.server.netty.handler.MultiplexedServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogConnectionEncoder;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogFrameListener;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.nio.channels.ClosedChannelException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

@Internal
public final class Http2ServerHandler
extends MultiplexedServerHandler
implements Http2FrameListener {
    private static final Map<Http2Error, Exception> HTTP2_ERRORS = new EnumMap<Http2Error, Exception>(Http2Error.class);
    private Http2ConnectionHandler connectionHandler;
    private Http2Connection.PropertyKey streamKey;
    private boolean reading = false;
    private boolean upgradedFromHttp1 = false;

    Http2ServerHandler(RequestHandler requestHandler) {
        super(requestHandler);
    }

    private void init(Http2ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.streamKey = connectionHandler.connection().newKey();
    }

    @Override
    void flush() {
        if (!this.reading) {
            this.connectionHandler.flush(this.ctx);
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        MultiplexedServerHandler.MultiplexedStream stream = (MultiplexedServerHandler.MultiplexedStream)this.connectionHandler.connection().stream(streamId).getProperty(this.streamKey);
        if (stream == null) {
            return padding;
        }
        return stream.onDataRead(data.retain(), endOfStream) + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, 0, (short)16, false, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream;
        io.netty.handler.codec.http2.Http2Stream str = this.connectionHandler.connection().stream(streamId);
        Http2Stream existing = (Http2Stream)str.setProperty(this.streamKey, (Object)(stream = new Http2Stream(str)));
        if (existing != null) {
            str.setProperty(this.streamKey, (Object)existing);
            return;
        }
        stream.onHeadersRead(HttpConversionUtil.toHttpRequest((int)streamId, (Http2Headers)headers, (boolean)true), endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        MultiplexedServerHandler.MultiplexedStream stream = (MultiplexedServerHandler.MultiplexedStream)this.connectionHandler.connection().stream(streamId).getProperty(this.streamKey);
        if (stream != null) {
            Http2Error http2Error = Http2Error.valueOf((long)errorCode);
            if (http2Error == null) {
                http2Error = Http2Error.INTERNAL_ERROR;
            }
            stream.onRstStreamRead(HTTP2_ERRORS.get(http2Error));
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        Http2Error http2Error = Http2Error.valueOf((long)errorCode);
        if (http2Error == null) {
            http2Error = Http2Error.INTERNAL_ERROR;
        }
        Exception e = HTTP2_ERRORS.get(http2Error);
        this.connectionHandler.connection().forEachActiveStream(s -> {
            Http2Stream stream = (Http2Stream)s.getProperty(this.streamKey);
            if (stream != null) {
                stream.onGoAwayRead(e);
            }
            return true;
        });
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    static {
        for (Http2Error value : Http2Error.values()) {
            Object e = value == Http2Error.CANCEL ? StacklessStreamClosedChannelException.INSTANCE : new StacklessHttp2Exception(value);
            HTTP2_ERRORS.put(value, (Exception)e);
        }
    }

    private final class Http2Stream
    extends MultiplexedServerHandler.MultiplexedStream {
        final io.netty.handler.codec.http2.Http2Stream stream;
        private boolean closeInput;

        Http2Stream(io.netty.handler.codec.http2.Http2Stream stream) {
            super(Http2ServerHandler.this);
            this.closeInput = false;
            this.stream = stream;
        }

        @Override
        void notifyDataConsumed(int n) {
            if (this.stream.id() == 1 && Http2ServerHandler.this.upgradedFromHttp1) {
                return;
            }
            try {
                ((Http2LocalFlowController)Http2ServerHandler.this.connectionHandler.connection().local().flowController()).consumeBytes(this.stream, n);
            }
            catch (Http2Exception e) {
                throw new IllegalArgumentException("n > unconsumedBytes", e);
            }
        }

        @Override
        boolean reset(Throwable cause) {
            if (cause instanceof Http2Exception) {
                Http2Exception h2e = (Http2Exception)cause;
                Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), h2e.error().code(), Http2ServerHandler.this.ctx.voidPromise());
                return true;
            }
            if (cause instanceof ByteBody.BodyDiscardedException) {
                Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), Http2Error.CANCEL.code(), Http2ServerHandler.this.ctx.voidPromise());
                return true;
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), Http2Error.INTERNAL_ERROR.code(), Http2ServerHandler.this.ctx.voidPromise());
            return false;
        }

        @Override
        void closeInput() {
            this.closeInput = true;
            if (this.stream.state() == Http2Stream.State.HALF_CLOSED_LOCAL) {
                Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), Http2Error.CANCEL.code(), Http2ServerHandler.this.ctx.voidPromise());
                Http2ServerHandler.this.flush();
            }
        }

        @Override
        void writeHeaders(HttpResponse headers, boolean endStream, ChannelPromise promise) {
            if (endStream && this.closeInput) {
                promise = promise.unvoid();
                promise.addListener(future -> this.closeInput());
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeHeaders(Http2ServerHandler.this.ctx, this.stream.id(), HttpConversionUtil.toHttp2Headers((HttpMessage)headers, (boolean)true), 0, endStream, promise);
        }

        @Override
        void writeData0(ByteBuf data, boolean endStream, ChannelPromise promise) {
            if (endStream && this.closeInput) {
                promise = promise.unvoid();
                promise.addListener(future -> this.closeInput());
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeData(Http2ServerHandler.this.ctx, this.stream.id(), data, 0, endStream, promise);
        }
    }

    private static class StacklessStreamClosedChannelException
    extends ClosedChannelException {
        static final StacklessStreamClosedChannelException INSTANCE = new StacklessStreamClosedChannelException();

        private StacklessStreamClosedChannelException() {
        }

        @Override
        public String getMessage() {
            return "HTTP2 peer cancelled request stream";
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class StacklessHttp2Exception
    extends Http2Exception {
        StacklessHttp2Exception(Http2Error error) {
            super(error, "HTTP/2 peer sent error: " + String.valueOf(error));
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class ConnectionHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<ConnectionHandler, ConnectionHandlerBuilder> {
        private final Http2ServerHandler frameListener;
        private Http2AccessLogManager.Factory accessLogManagerFactory;
        private Http2AccessLogManager accessLogManager;

        public ConnectionHandlerBuilder(RequestHandler requestHandler) {
            this.frameListener = new Http2ServerHandler(requestHandler);
        }

        public ConnectionHandlerBuilder frameLogger(Http2FrameLogger frameLogger) {
            return (ConnectionHandlerBuilder)super.frameLogger(frameLogger);
        }

        public ConnectionHandlerBuilder validateHeaders(boolean validateHeaders) {
            return (ConnectionHandlerBuilder)super.validateHeaders(validateHeaders);
        }

        public ConnectionHandlerBuilder initialSettings(Http2Settings settings) {
            return (ConnectionHandlerBuilder)super.initialSettings(settings);
        }

        public ConnectionHandlerBuilder accessLogManagerFactory(@Nullable Http2AccessLogManager.Factory accessLogManagerFactory) {
            this.accessLogManagerFactory = accessLogManagerFactory;
            return this;
        }

        public ConnectionHandlerBuilder compressor(HttpCompressionStrategy compressionStrategy) {
            if (compressionStrategy.isEnabled()) {
                this.frameListener.compressor(new Compressor(compressionStrategy));
            }
            return this;
        }

        public ConnectionHandlerBuilder bodySizeLimits(BodySizeLimits bodySizeLimits) {
            this.frameListener.bodySizeLimits = bodySizeLimits;
            return this;
        }

        public ConnectionHandler build() {
            this.connection((Http2Connection)new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams()));
            Object fl = new DelegatingDecompressorFrameListener(this.connection(), (Http2FrameListener)this.frameListener, false);
            if (this.accessLogManagerFactory != null) {
                this.accessLogManager = new Http2AccessLogManager(this.accessLogManagerFactory, this.connection());
                fl = new Http2AccessLogFrameListener((Http2FrameListener)fl, this.accessLogManager);
            }
            this.frameListener((Http2FrameListener)fl);
            return (ConnectionHandler)super.build();
        }

        protected ConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
            if (this.accessLogManager != null) {
                encoder = new Http2AccessLogConnectionEncoder((Http2ConnectionEncoder)encoder, this.accessLogManager);
            }
            ConnectionHandler ch = new ConnectionHandler(decoder, (Http2ConnectionEncoder)encoder, initialSettings, this.decoupleCloseAndGoAway(), this.flushPreface(), this.frameListener, this.accessLogManager);
            this.frameListener.init(ch);
            return ch;
        }
    }

    public static final class ConnectionHandler
    extends Http2ConnectionHandler {
        private final Http2ServerHandler handler;
        @Nullable
        private final Http2AccessLogManager accessLogManager;

        private ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, boolean flushPreface, Http2ServerHandler handler, Http2AccessLogManager accessLogManager) {
            super(decoder, encoder, initialSettings, decoupleCloseAndGoAway, flushPreface);
            this.handler = handler;
            this.accessLogManager = accessLogManager;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.handler.ctx = ctx;
            super.handlerAdded(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.handler.reading = true;
            super.channelRead(ctx, msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.connection().forEachActiveStream(s -> {
                Http2Stream stream = (Http2Stream)s.getProperty(this.handler.streamKey);
                if (stream != null) {
                    stream.devolveToStreaming();
                }
                return true;
            });
            this.handler.reading = false;
            super.channelReadComplete(ctx);
        }

        protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved0(ctx);
            this.connection().forEachActiveStream(s -> {
                Http2Stream stream = (Http2Stream)s.getProperty(this.handler.streamKey);
                if (stream != null) {
                    stream.onGoAwayRead(StacklessStreamClosedChannelException.INSTANCE);
                }
                return true;
            });
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent idle;
            if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
                HttpServerUpgradeHandler.UpgradeEvent upgrade = (HttpServerUpgradeHandler.UpgradeEvent)evt;
                this.handler.upgradedFromHttp1 = true;
                FullHttpRequest fhr = upgrade.upgradeRequest();
                if (this.accessLogManager != null) {
                    this.accessLogManager.logHeaders(ctx, 1, (HttpRequest)fhr);
                }
                io.netty.handler.codec.http2.Http2Stream cs = this.connection().stream(1);
                this.handleFakeRequest(cs, fhr);
            } else if (evt instanceof IdleStateEvent && (idle = (IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                ctx.close();
            }
            super.userEventTriggered(ctx, evt);
        }

        public void handleFakeRequest(io.netty.handler.codec.http2.Http2Stream onStream, FullHttpRequest fhr) {
            Http2ServerHandler http2ServerHandler = this.handler;
            Objects.requireNonNull(http2ServerHandler);
            Http2Stream stream = http2ServerHandler.new Http2Stream(onStream);
            onStream.setProperty(this.handler.streamKey, (Object)stream);
            boolean empty = !fhr.content().isReadable();
            stream.onHeadersRead((HttpRequest)fhr, empty);
            if (!empty) {
                stream.onDataRead(fhr.content(), true);
            }
        }
    }
}

