/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;

final class LocalPortElement
implements LogElement {
    public static final String LOCAL_PORT = "p";
    static final LocalPortElement INSTANCE = new LocalPortElement();

    private LocalPortElement() {
    }

    @Override
    public Set<LogElement.Event> events() {
        return LogElement.Event.REQUEST_HEADERS_EVENTS;
    }

    @Override
    public String onRequestHeaders(@NonNull ConnectionMetadata metadata, @NonNull String method, @NonNull HttpHeaders headers, @NonNull String uri, @NonNull String protocol) {
        SocketAddress localAddress = metadata.localAddress().orElse(null);
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)localAddress;
            return Integer.toString(addr.getPort());
        }
        return "-";
    }

    @Override
    public LogElement copy() {
        return this;
    }

    public String toString() {
        return "%p";
    }
}

