/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.AbstractServerSslBuilder;
import io.micronaut.http.server.netty.ssl.BuildSelfSignedCondition;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.ssl.SslEnabledCondition;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import jakarta.inject.Singleton;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Optional;

@Requirements(value={@Requires(condition=SslEnabledCondition.class), @Requires(condition=SelfSignedConfigured.class)})
@Singleton
@Internal
public class SelfSignedSslBuilder
extends AbstractServerSslBuilder
implements ServerSslBuilder {
    private final ServerSslConfiguration ssl;

    public SelfSignedSslBuilder(HttpServerConfiguration serverConfiguration, ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super(resourceResolver, serverConfiguration);
        this.ssl = ssl;
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        store.load(null, null);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        store.setKeyEntry("key", ssc.key(), null, new Certificate[]{ssc.cert()});
        return Optional.of(store);
    }

    static class SelfSignedConfigured
    extends BuildSelfSignedCondition {
        SelfSignedConfigured() {
        }

        @Override
        protected boolean validate(ConditionContext context, boolean deprecatedPropertyFound, boolean newPropertyFound) {
            if (!deprecatedPropertyFound && !newPropertyFound) {
                context.fail("Neither the old deprecated micronaut.ssl.build-self-signed, nor the new micronaut.server.ssl.build-self-signed were enabled.");
                return false;
            }
            return true;
        }
    }
}

