/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function;

import io.micronaut.context.BeanContext;
import io.micronaut.context.processor.BeanDefinitionProcessor;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.FunctionBean;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@Singleton
public class DefaultLocalFunctionRegistry
implements BeanDefinitionProcessor<FunctionBean>,
LocalFunctionRegistry,
MediaTypeCodecRegistry {
    private final Map<String, ExecutableMethod<?, ?>> consumers = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> functions = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> biFunctions = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> suppliers = new LinkedHashMap(1);
    private final MediaTypeCodecRegistry decoderRegistry;

    public DefaultLocalFunctionRegistry(MediaTypeCodec ... decoders) {
        this.decoderRegistry = MediaTypeCodecRegistry.of((MediaTypeCodec[])decoders);
    }

    @Inject
    public DefaultLocalFunctionRegistry(List<MediaTypeCodec> decoders) {
        this.decoderRegistry = MediaTypeCodecRegistry.of(decoders);
    }

    public DefaultLocalFunctionRegistry(MediaTypeCodecRegistry codecRegistry) {
        this.decoderRegistry = codecRegistry;
    }

    public Optional<? extends ExecutableMethod<?, ?>> findFirst() {
        return Stream.of(this.functions, this.suppliers, this.consumers, this.biFunctions).map(all -> {
            Collection values = all.values();
            return values.stream().findFirst();
        }).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<? extends ExecutableMethod<?, ?>> find(String name) {
        return Stream.of(this.functions, this.suppliers, this.consumers, this.biFunctions).flatMap(map -> {
            ExecutableMethod method = (ExecutableMethod)map.get(name);
            return Stream.ofNullable(method);
        }).findFirst();
    }

    @Override
    public Map<String, URI> getAvailableFunctions() {
        return Collections.emptyMap();
    }

    @Override
    public <T> Optional<ExecutableMethod<Supplier<T>, T>> findSupplier(String name) {
        ExecutableMethod<?, ?> method = this.suppliers.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<ExecutableMethod<Consumer<T>, Void>> findConsumer(String name) {
        ExecutableMethod<?, ?> method = this.consumers.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<ExecutableMethod<Function<T, R>, R>> findFunction(String name) {
        ExecutableMethod<?, ?> method = this.functions.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T, U, R> Optional<ExecutableMethod<BiFunction<T, U, R>, R>> findBiFunction(String name) {
        ExecutableMethod<?, ?> method = this.biFunctions.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public void process(BeanDefinition<?> beanDefinition, BeanContext beanContext) {
        for (ExecutableMethod executableMethod : beanDefinition.getExecutableMethods()) {
            String methodName;
            if (!executableMethod.hasAnnotation(FunctionBean.class)) continue;
            String functionId = executableMethod.stringValue(FunctionBean.class).orElse(null);
            Class declaringType = executableMethod.getDeclaringType();
            if (StringUtils.isEmpty((CharSequence)functionId)) {
                String typeName = declaringType.getSimpleName();
                functionId = typeName.contains("$") ? NameUtils.hyphenate((String)executableMethod.getMethodName()) : NameUtils.hyphenate((String)typeName);
            }
            if ((methodName = (String)executableMethod.stringValue(FunctionBean.class, "method").orElse(null)) != null && !methodName.equals(executableMethod.getMethodName())) continue;
            if (Function.class.isAssignableFrom(declaringType) && executableMethod.getMethodName().equals("apply")) {
                this.registerFunction(executableMethod, functionId);
                continue;
            }
            if (Consumer.class.isAssignableFrom(declaringType) && executableMethod.getMethodName().equals("accept")) {
                this.registerConsumer(executableMethod, functionId);
                continue;
            }
            if (BiFunction.class.isAssignableFrom(declaringType) && executableMethod.getMethodName().equals("apply")) {
                this.registerBiFunction(executableMethod, functionId);
                continue;
            }
            if (!Supplier.class.isAssignableFrom(declaringType) || !executableMethod.getMethodName().equals("get")) continue;
            this.registerSupplier(executableMethod, functionId);
        }
    }

    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType) {
        return this.decoderRegistry.findCodec(mediaType);
    }

    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType, Class<?> type) {
        return this.decoderRegistry.findCodec(mediaType, type);
    }

    public Collection<MediaTypeCodec> getCodecs() {
        return this.decoderRegistry.getCodecs();
    }

    private void registerSupplier(ExecutableMethod<?, ?> method, String functionId) {
        this.suppliers.put(functionId, method);
    }

    private void registerBiFunction(ExecutableMethod<?, ?> method, String functionId) {
        this.biFunctions.put(functionId, method);
    }

    private void registerConsumer(ExecutableMethod<?, ?> method, String functionId) {
        this.consumers.put(functionId, method);
    }

    private void registerFunction(ExecutableMethod<?, ?> method, String functionId) {
        this.functions.put(functionId, method);
    }
}

