/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.executor;

import io.micronaut.core.cli.CommandLine;
import io.micronaut.function.executor.StreamFunctionExecutor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;

public class FunctionApplication
extends StreamFunctionExecutor {
    public static final String DATA_OPTION = "d";
    public static final String DEBUG_OPTIONS = "x";

    public static void main(String ... args) {
        FunctionApplication functionApplication = new FunctionApplication();
        FunctionApplication.run(functionApplication, args);
    }

    public static void run(StreamFunctionExecutor functionExecutor, String ... args) {
        FunctionApplication.parseData(args, (data, isDebug) -> {
            try (InputStream input = data != null ? new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)) : System.in;){
                functionExecutor.execute(input, System.out);
            }
            catch (Exception e) {
                FunctionApplication.exitWithError(isDebug, e);
            }
        });
    }

    static void exitWithError(Boolean isDebug, Exception e) {
        System.err.println("Error executing function (Use -x for more information): " + e.getMessage());
        if (isDebug.booleanValue()) {
            System.err.println();
            System.err.println("Error Detail");
            System.err.println("------------");
            e.printStackTrace(System.err);
        }
        System.exit(1);
    }

    static void parseData(String[] args, BiConsumer<String, Boolean> data) {
        CommandLine commandLine = FunctionApplication.parseCommandLine(args);
        Object value = commandLine.optionValue(DATA_OPTION);
        if (value != null) {
            data.accept(value.toString(), commandLine.hasOption(DEBUG_OPTIONS));
        } else {
            data.accept(null, commandLine.hasOption(DEBUG_OPTIONS));
        }
    }

    static void exitWithNoData() {
        System.err.println("No data specified. Use -d to specify the data");
        System.exit(1);
    }

    static CommandLine parseCommandLine(String[] args) {
        return CommandLine.build().addOption(DATA_OPTION, "For passing the data").addOption(DEBUG_OPTIONS, "For outputting debug information").parse(args);
    }
}

