/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.openapi.tasks;

import io.micronaut.gradle.openapi.ParameterMappingModel;
import io.micronaut.gradle.openapi.ResponseBodyMappingModel;
import io.micronaut.gradle.openapi.tasks.AbstractOpenApiWorkAction;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public abstract class AbstractOpenApiGenerator<W extends AbstractOpenApiWorkAction<P>, P extends AbstractOpenApiWorkAction.OpenApiParameters>
extends DefaultTask {
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getDefinitionFile();

    @Input
    public abstract Property<String> getLang();

    @Input
    public abstract Property<String> getInvokerPackageName();

    @Input
    public abstract Property<String> getApiPackageName();

    @Input
    public abstract Property<String> getModelPackageName();

    @Input
    public abstract Property<Boolean> getUseBeanValidation();

    @Input
    public abstract Property<Boolean> getUseOneOfInterfaces();

    @Input
    public abstract Property<Boolean> getUseOptional();

    @Input
    public abstract Property<Boolean> getUseReactive();

    @Input
    public abstract ListProperty<String> getOutputKinds();

    @Input
    public abstract Property<String> getSerializationFramework();

    @Input
    public abstract Property<Boolean> getAlwaysUseGenerateHttpResponse();

    @Input
    public abstract Property<Boolean> getGenerateHttpResponseWhereRequired();

    @Input
    public abstract Property<String> getDateTimeFormat();

    @Input
    public abstract ListProperty<ParameterMappingModel> getParameterMappings();

    @Input
    public abstract Property<Boolean> getLombok();

    @Input
    public abstract Property<Boolean> getKsp();

    @Input
    public abstract Property<Boolean> getGeneratedAnnotation();

    @Input
    public abstract Property<Boolean> getFluxForArrays();

    @Input
    public abstract ListProperty<ResponseBodyMappingModel> getResponseBodyMappings();

    @Input
    public abstract MapProperty<String, String> getSchemaMapping();

    @Input
    public abstract MapProperty<String, String> getImportMapping();

    @Input
    public abstract MapProperty<String, String> getNameMapping();

    @Input
    public abstract MapProperty<String, String> getTypeMapping();

    @Input
    public abstract MapProperty<String, String> getEnumNameMapping();

    @Input
    public abstract MapProperty<String, String> getModelNameMapping();

    @Input
    public abstract MapProperty<String, String> getInlineSchemaNameMapping();

    @Input
    public abstract MapProperty<String, String> getInlineSchemaOption();

    @Input
    public abstract MapProperty<String, String> getOpenapiNormalizer();

    @Optional
    @Input
    public abstract Property<String> getApiNamePrefix();

    @Optional
    @Input
    public abstract Property<String> getApiNameSuffix();

    @Optional
    @Input
    public abstract Property<String> getModelNamePrefix();

    @Optional
    @Input
    public abstract Property<String> getModelNameSuffix();

    @Optional
    @Input
    public abstract Property<Boolean> getUseEnumCaseInsensitive();

    @Optional
    @Input
    public abstract Property<Boolean> getGenerateSwaggerAnnotations();

    @Optional
    @Input
    public abstract Property<Boolean> getImplicitHeaders();

    @Optional
    @Input
    public abstract Property<String> getImplicitHeadersRegex();

    @Optional
    @Input
    public abstract ListProperty<String> getAdditionalEnumTypeAnnotations();

    @Optional
    @Input
    public abstract ListProperty<String> getAdditionalModelTypeAnnotations();

    @Optional
    @Input
    public abstract ListProperty<String> getAdditionalOneOfTypeAnnotations();

    @Optional
    @Input
    public abstract MapProperty<String, Object> getAdditionalProperties();

    @Optional
    @Input
    public abstract Property<Boolean> getUseJakartaEe();

    @Optional
    @Input
    public abstract Property<Boolean> getSortParamsByRequiredFlag();

    @Optional
    @Input
    public abstract Property<Boolean> getSkipOperationExample();

    @Optional
    @Input
    public abstract Property<Boolean> getSkipSortingOperations();

    @Optional
    @Input
    public abstract Property<String> getRemoveOperationIdPrefixDelimiter();

    @Optional
    @Input
    public abstract Property<Integer> getRemoveOperationIdPrefixCount();

    @Optional
    @Input
    public abstract Property<Boolean> getSortModelPropertiesByRequiredFlag();

    @Optional
    @Input
    public abstract Property<Boolean> getEnsureUniqueParams();

    @Optional
    @Input
    public abstract Property<Boolean> getAllowUnicodeIdentifiers();

    @Optional
    @Input
    public abstract Property<Boolean> getPrependFormOrBodyParameters();

    @Optional
    @Input
    public abstract Property<Boolean> getCoroutines();

    @Optional
    @Input
    public abstract Property<Boolean> getUseSealed();

    @Optional
    @Input
    public abstract Property<Boolean> getJsonIncludeAlwaysForRequiredFields();

    @Optional
    @Input
    public abstract Property<Boolean> getRequiredPropertiesInConstructor();

    @Optional
    @Input
    public abstract Property<Boolean> getGenerateControllerAsAbstract();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Internal
    protected abstract Class<W> getWorkerAction();

    protected abstract void configureWorkerParameters(P var1);

    @TaskAction
    public final void execute() {
        this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getClasspath()})).submit(this.getWorkerAction(), params -> {
            params.getLang().set(this.getLang());
            params.getApiPackageName().set(this.getApiPackageName());
            params.getInvokerPackageName().set(this.getInvokerPackageName());
            params.getSerializationFramework().set(this.getSerializationFramework());
            params.getModelPackageName().set(this.getModelPackageName());
            params.getUseBeanValidation().set(this.getUseBeanValidation());
            params.getUseOneOfInterfaces().set(this.getUseOneOfInterfaces());
            params.getUseOptional().set(this.getUseOptional());
            params.getUseReactive().set(this.getUseReactive());
            params.getDefinitionFile().set((Provider)this.getDefinitionFile());
            params.getOutputDirectory().set((Provider)this.getOutputDirectory());
            params.getOutputKinds().set(this.getOutputKinds());
            params.getAlwaysUseGenerateHttpResponse().set(this.getAlwaysUseGenerateHttpResponse());
            params.getGenerateHttpResponseWhereRequired().set(this.getGenerateHttpResponseWhereRequired());
            params.getDateTimeFormat().set(this.getDateTimeFormat());
            params.getParameterMappings().set(this.getParameterMappings());
            params.getResponseBodyMappings().set(this.getResponseBodyMappings());
            params.getFluxForArrays().set(this.getFluxForArrays());
            params.getGeneratedAnnotation().set(this.getGeneratedAnnotation());
            params.getLombok().set(this.getLombok());
            params.getKsp().set(this.getKsp());
            params.getSchemaMapping().set(this.getSchemaMapping());
            params.getImportMapping().set(this.getImportMapping());
            params.getNameMapping().set(this.getNameMapping());
            params.getTypeMapping().set(this.getTypeMapping());
            params.getEnumNameMapping().set(this.getEnumNameMapping());
            params.getModelNameMapping().set(this.getModelNameMapping());
            params.getInlineSchemaNameMapping().set(this.getInlineSchemaNameMapping());
            params.getInlineSchemaOption().set(this.getInlineSchemaOption());
            params.getOpenapiNormalizer().set(this.getOpenapiNormalizer());
            params.getApiNamePrefix().set(this.getApiNamePrefix().orElse((Object)""));
            params.getApiNameSuffix().set(this.getApiNameSuffix().orElse((Object)""));
            params.getModelNamePrefix().set(this.getModelNamePrefix().orElse((Object)""));
            params.getModelNameSuffix().set(this.getModelNameSuffix().orElse((Object)""));
            params.getUseEnumCaseInsensitive().set(this.getUseEnumCaseInsensitive());
            params.getGenerateSwaggerAnnotations().set(this.getGenerateSwaggerAnnotations());
            params.getImplicitHeaders().set(this.getImplicitHeaders());
            params.getImplicitHeadersRegex().set(this.getImplicitHeadersRegex().orElse((Object)""));
            params.getAdditionalEnumTypeAnnotations().set(this.getAdditionalEnumTypeAnnotations());
            params.getAdditionalModelTypeAnnotations().set(this.getAdditionalModelTypeAnnotations());
            params.getAdditionalOneOfTypeAnnotations().set(this.getAdditionalOneOfTypeAnnotations());
            params.getAdditionalProperties().set(this.getAdditionalProperties());
            params.getUseJakartaEe().set((Object)((Boolean)this.getUseJakartaEe().get()));
            params.getSortParamsByRequiredFlag().set((Object)((Boolean)this.getSortParamsByRequiredFlag().get()));
            params.getSkipOperationExample().set((Object)((Boolean)this.getSkipOperationExample().get()));
            params.getSkipSortingOperations().set((Object)((Boolean)this.getSkipSortingOperations().get()));
            params.getRemoveOperationIdPrefixDelimiter().set((Object)((String)this.getRemoveOperationIdPrefixDelimiter().get()));
            params.getRemoveOperationIdPrefixCount().set((Object)((Integer)this.getRemoveOperationIdPrefixCount().get()));
            params.getSortModelPropertiesByRequiredFlag().set((Object)((Boolean)this.getSortModelPropertiesByRequiredFlag().get()));
            params.getEnsureUniqueParams().set((Object)((Boolean)this.getEnsureUniqueParams().get()));
            params.getAllowUnicodeIdentifiers().set((Object)((Boolean)this.getAllowUnicodeIdentifiers().get()));
            params.getPrependFormOrBodyParameters().set((Object)((Boolean)this.getPrependFormOrBodyParameters().get()));
            params.getCoroutines().set((Object)((Boolean)this.getCoroutines().get()));
            params.getUseSealed().set((Object)((Boolean)this.getUseSealed().get()));
            params.getJsonIncludeAlwaysForRequiredFields().set((Object)((Boolean)this.getJsonIncludeAlwaysForRequiredFields().get()));
            params.getRequiredPropertiesInConstructor().set((Object)((Boolean)this.getRequiredPropertiesInConstructor().get()));
            params.getGenerateControllerAsAbstract().set((Object)((Boolean)this.getGenerateControllerAsAbstract().get()));
            this.configureWorkerParameters(params);
        });
    }
}

