/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.async.AbstractAsyncSpecificationInterceptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Internal
public class FindPageAsyncSpecificationInterceptor
extends AbstractAsyncSpecificationInterceptor<Object, Object> {
    protected FindPageAsyncSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        if (context.getExecutableMethod().isSuspend() ? context.getParameterValues().length != 3 : context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            return this.findAllAsync(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE).thenApply(iterable -> {
                List resultList = CollectionUtils.iterableToList((Iterable)iterable);
                return Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size()));
            });
        }
        return this.findAllAsync(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE).thenCompose(iterable -> pageable.requestTotal() ? this.countAsync(methodKey, context).thenApply(count -> Page.of((List)CollectionUtils.iterableToList((Iterable)iterable), (Pageable)pageable, (Long)count.longValue())) : CompletableFuture.completedFuture(Page.of((List)CollectionUtils.iterableToList((Iterable)iterable), (Pageable)pageable, null)));
    }
}

