/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityRoot;
import io.micronaut.data.runtime.criteria.metamodel.StaticMetamodelInitializer;
import jakarta.persistence.criteria.CriteriaBuilder;

@Internal
final class RuntimePersistentEntityCriteriaQuery<T>
extends AbstractPersistentEntityCriteriaQuery<T> {
    private final AbstractCriteriaBuilder criteriaBuilder;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final StaticMetamodelInitializer staticMetamodelInitializer;

    public RuntimePersistentEntityCriteriaQuery(AbstractCriteriaBuilder criteriaBuilder, StaticMetamodelInitializer staticMetamodelInitializer, Class<T> resultType, RuntimeEntityRegistry runtimeEntityRegistry) {
        super(resultType, (CriteriaBuilder)criteriaBuilder);
        this.criteriaBuilder = criteriaBuilder;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.staticMetamodelInitializer = staticMetamodelInitializer;
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        return this.from((PersistentEntity)this.runtimeEntityRegistry.getEntity(entityClass));
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        RuntimePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        RuntimePersistentEntity runtimePersistentEntity = (RuntimePersistentEntity)persistentEntity;
        this.staticMetamodelInitializer.initializeMetadata(runtimePersistentEntity);
        this.entityRoot = newEntityRoot = new RuntimePersistentEntityRoot(runtimePersistentEntity, (CriteriaBuilder)this.criteriaBuilder);
        return newEntityRoot;
    }
}

