/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityJoinSupport;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.RuntimePersistentAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentCollectionAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentListAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentPropertyPathImpl;
import io.micronaut.data.runtime.criteria.RuntimePersistentSetAssociationPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Internal
abstract class AbstractRuntimePersistentEntityJoinSupport<T, E>
extends AbstractPersistentEntityJoinSupport<T, E> {
    private final CriteriaBuilder criteriaBuilder;

    AbstractRuntimePersistentEntityJoinSupport(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    protected abstract List<Association> getCurrentPath();

    public abstract RuntimePersistentEntity<E> getPersistentEntity();

    protected <Y> PersistentAssociationPath<E, Y> createJoinAssociation(Association association, Join.Type associationJoinType, String alias) {
        Class type = ((RuntimeAssociation)association).getProperty().getType();
        RuntimeAssociation runtimeAssociation = (RuntimeAssociation)association;
        if (List.class.isAssignableFrom(type)) {
            return new RuntimePersistentListAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new RuntimePersistentSetAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new RuntimePersistentCollectionAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        return new RuntimePersistentAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
    }

    public <Y> PersistentPropertyPath<Y> get(String attributeName) {
        RuntimePersistentProperty property = this.getPersistentEntity().getPropertyByName(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        AbstractRuntimePersistentEntityJoinSupport abstractRuntimePersistentEntityJoinSupport = this;
        if (abstractRuntimePersistentEntityJoinSupport instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)abstractRuntimePersistentEntityJoinSupport;
            List associations = associationPath.getAssociations();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(associationPath.getAssociation());
            return new RuntimePersistentPropertyPathImpl((Path<?>)this, (List<Association>)newAssociations, property, this.criteriaBuilder);
        }
        return new RuntimePersistentPropertyPathImpl((Path<?>)this, Collections.emptyList(), property, this.criteriaBuilder);
    }
}

