/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.QueryResult;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.BeanPropertyWithAnnotationMetadata;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.QueryResultInfo;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.JsonQueryResultMapper;
import io.micronaut.data.runtime.mapper.sql.SqlJsonValueMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlJsonColumnMapperProvider;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.internal.BasicStoredQuery;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.json.JsonMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public abstract class AbstractSqlRepositoryOperations<RS, PS, Exc extends Exception>
extends AbstractRepositoryOperations
implements ApplicationContextProvider,
PreparedQueryDecorator,
MethodContextAwareStoredQueryDecorator,
HintsCapableRepository {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected final String dataSourceName;
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final JsonMapper jsonMapper;
    protected final SqlJsonColumnMapperProvider<RS> sqlJsonColumnMapperProvider;
    protected final Map<Class, SqlQueryBuilder> queryBuilders = new HashMap<Class, SqlQueryBuilder>(10);
    protected final Map<Class, String> repositoriesWithHardcodedDataSource = new HashMap<Class, String>(10);
    private final Map<QueryKey, SqlStoredQuery> entityInserts = new ConcurrentHashMap<QueryKey, SqlStoredQuery>(10);
    private final Map<QueryKey, SqlStoredQuery> entityUpdates = new ConcurrentHashMap<QueryKey, SqlStoredQuery>(10);
    private final Map<Association, String> associationInserts = new ConcurrentHashMap<Association, String>(10);

    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, BeanContext beanContext, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, JsonMapper jsonMapper, SqlJsonColumnMapperProvider<RS> sqlJsonColumnMapperProvider) {
        super(dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        this.dataSourceName = dataSourceName;
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        this.jsonMapper = jsonMapper;
        this.sqlJsonColumnMapperProvider = sqlJsonColumnMapperProvider;
        Collection beanDefinitions = beanContext.getBeanDefinitions(Object.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse(null);
            Class beanType = beanDefinition.getBeanType();
            if (targetDs == null || targetDs.equalsIgnoreCase(dataSourceName)) {
                SqlQueryBuilder queryBuilder = new SqlQueryBuilder(beanDefinition.getAnnotationMetadata());
                this.queryBuilders.put(beanType, queryBuilder);
                continue;
            }
            this.repositoriesWithHardcodedDataSource.put(beanType, targetDs);
        }
    }

    @Override
    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return new DefaultSqlPreparedQuery<E, R>(preparedQuery);
    }

    @Override
    public <E, R> StoredQuery<E, R> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery) {
        Class<?> repositoryType = context.getTarget().getClass();
        SqlQueryBuilder queryBuilder = this.findQueryBuilder(repositoryType);
        RuntimePersistentEntity runtimePersistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        return new DefaultSqlStoredQuery<E, R>(storedQuery, runtimePersistentEntity, queryBuilder);
    }

    protected <T, R> PS prepareStatement(StatementSupplier<PS> statementFunction, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws Exc {
        PS ps;
        SqlPreparedQuery<T, R> sqlPreparedQuery = this.getSqlPreparedQuery(preparedQuery);
        sqlPreparedQuery.prepare(null);
        if (!isUpdate) {
            sqlPreparedQuery.attachPageable(preparedQuery.getPageable(), isSingleResult);
        }
        String query = sqlPreparedQuery.getQuery();
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        try {
            ps = statementFunction.create(query);
        }
        catch (Exception e) {
            throw new DataAccessException("Unable to prepare query [" + query + "]: " + e.getMessage(), (Throwable)e);
        }
        return ps;
    }

    protected void setStatementParameter(PS preparedStatement, int index, DataType dataType, JsonDataType jsonDataType, Object value, SqlStoredQuery<?, ?> storedQuery) {
        Dialect dialect = storedQuery.getDialect();
        switch (dataType) {
            case UUID: {
                if (value == null || !dialect.requiresStringUUID(dataType)) break;
                value = value.toString();
                break;
            }
            case JSON: {
                value = this.getJsonValue(storedQuery, jsonDataType, index, value);
                break;
            }
            case ENTITY: {
                if (value == null) break;
                RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                Object id = idReader.getProperty().get(value);
                if (id == null) {
                    throw new DataAccessException("Supplied entity is a transient instance: " + value);
                }
                this.setStatementParameter(preparedStatement, index, idReader.getDataType(), jsonDataType, id, storedQuery);
                return;
            }
        }
        dataType = dialect.getDataType(dataType);
        if (QUERY_LOG.isTraceEnabled()) {
            QUERY_LOG.trace("Binding parameter at position {} to value {} with data type: {}", new Object[]{index, value, dataType});
        }
        if (dataType == DataType.JSON && value != null) {
            this.preparedStatementWriter.setValue(preparedStatement, index, value);
            return;
        }
        this.preparedStatementWriter.setDynamic(preparedStatement, index, dataType, value);
    }

    private Object getJsonValue(SqlStoredQuery<?, ?> storedQuery, JsonDataType jsonDataType, int index, Object value) {
        if (value == null || value.getClass().equals(String.class)) {
            return value;
        }
        SqlJsonValueMapper sqlJsonValueMapper = this.sqlJsonColumnMapperProvider.getJsonValueMapper(storedQuery, jsonDataType, value);
        if (sqlJsonValueMapper == null) {
            throw new IllegalStateException("For JSON data types support Micronaut JsonMapper needs to be available on the classpath.");
        }
        try {
            return sqlJsonValueMapper.mapValue(value, jsonDataType);
        }
        catch (IOException e) {
            throw new DataAccessException("Failed setting JSON field parameter at index " + index, (Throwable)e);
        }
    }

    @NonNull
    protected <E> SqlStoredQuery<E, E> resolveEntityInsert(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<E> rootEntity, @NonNull RuntimePersistentEntity<E> persistentEntity) {
        return this.entityInserts.computeIfAbsent(new QueryKey(repositoryType, rootEntity), queryKey -> {
            SqlQueryBuilder queryBuilder = this.findQueryBuilder(repositoryType);
            QueryResult queryResult = queryBuilder.buildInsert(annotationMetadata, (PersistentEntity)persistentEntity);
            return new DefaultSqlStoredQuery(QueryResultStoredQuery.single(StoredQuery.OperationType.INSERT, "Custom insert", AnnotationMetadata.EMPTY_METADATA, queryResult, rootEntity), persistentEntity, queryBuilder);
        });
    }

    protected <T> String resolveAssociationInsert(Class repositoryType, RuntimePersistentEntity<T> persistentEntity, RuntimeAssociation<T> association) {
        return this.associationInserts.computeIfAbsent((Association)association, association1 -> {
            SqlQueryBuilder queryBuilder = this.findQueryBuilder(repositoryType);
            return queryBuilder.buildJoinTableInsert((PersistentEntity)persistentEntity, association1);
        });
    }

    @NonNull
    protected <E> SqlStoredQuery<E, E> resolveEntityUpdate(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<E> rootEntity, @NonNull RuntimePersistentEntity<E> persistentEntity) {
        QueryKey key = new QueryKey(repositoryType, rootEntity);
        return this.entityUpdates.computeIfAbsent(key, queryKey -> {
            SqlQueryBuilder queryBuilder = this.findQueryBuilder(repositoryType);
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            QueryModel queryModel = QueryModel.from((PersistentEntity)persistentEntity).idEq((Object)new QueryParameter(idName));
            List<String> updateProperties = persistentEntity.getPersistentProperties().stream().filter(p -> {
                Association association;
                return (!(p instanceof Association) || !(association = (Association)p).isForeignKey()) && p.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true) != false;
            }).map(PersistentProperty::getName).toList();
            QueryResult queryResult = queryBuilder.buildUpdate(annotationMetadata, queryModel, updateProperties);
            return new DefaultSqlStoredQuery(QueryResultStoredQuery.single(StoredQuery.OperationType.UPDATE, "Custom update", AnnotationMetadata.EMPTY_METADATA, queryResult, rootEntity), persistentEntity, queryBuilder);
        });
    }

    protected <T> SqlStoredQuery<T, ?> resolveSqlInsertAssociation(Class<?> repositoryType, RuntimeAssociation<T> association, RuntimePersistentEntity<T> persistentEntity, T entity) {
        String sqlInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
        SqlQueryBuilder queryBuilder = this.findQueryBuilder(repositoryType);
        ArrayList<QueryParameterBinding> parameters = new ArrayList<QueryParameterBinding>();
        for (final Map.Entry<PersistentProperty, Object> property : this.idPropertiesWithValues((PersistentProperty)persistentEntity.getIdentity(), entity).toList()) {
            parameters.add(new QueryParameterBinding(){

                public String getName() {
                    return ((PersistentProperty)property.getKey()).getName();
                }

                public DataType getDataType() {
                    return ((PersistentProperty)property.getKey()).getDataType();
                }

                public JsonDataType getJsonDataType() {
                    return ((PersistentProperty)property.getKey()).getJsonDataType();
                }

                public Object getValue() {
                    return property.getValue();
                }
            });
        }
        for (final PersistentPropertyPath pp : this.idProperties((PersistentProperty)association.getAssociatedEntity().getIdentity()).toList()) {
            parameters.add(new QueryParameterBinding(){

                public String getName() {
                    return pp.getProperty().getName();
                }

                public DataType getDataType() {
                    return pp.getProperty().getDataType();
                }

                public JsonDataType getJsonDataType() {
                    return pp.getProperty().getJsonDataType();
                }

                public String[] getPropertyPath() {
                    return pp.getArrayPath();
                }
            });
        }
        RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
        return new DefaultSqlStoredQuery(new BasicStoredQuery(sqlInsert, new String[0], parameters, persistentEntity.getIntrospection().getBeanType(), Object.class, StoredQuery.OperationType.INSERT), associatedEntity, queryBuilder);
    }

    private SqlQueryBuilder findQueryBuilder(Class<?> repositoryType) {
        SqlQueryBuilder queryBuilder = this.queryBuilders.get(repositoryType);
        if (queryBuilder != null) {
            return queryBuilder;
        }
        String hardcodedDatasource = this.repositoriesWithHardcodedDataSource.get(repositoryType);
        if (hardcodedDatasource != null) {
            throw new IllegalStateException("Repository [" + repositoryType + "] requires datasource: [" + hardcodedDatasource + "] but this repository operations uses: [" + this.dataSourceName + "]");
        }
        throw new IllegalStateException("Cannot find a query builder for repository: [" + repositoryType + "]");
    }

    private Stream<PersistentPropertyPath> idProperties(PersistentProperty property) {
        ArrayList paths = new ArrayList();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)property, (associations, persistentProperty) -> paths.add(new PersistentPropertyPath(associations, property)));
        return paths.stream();
    }

    private Stream<Map.Entry<PersistentProperty, Object>> idPropertiesWithValues(PersistentProperty property, Object value) {
        ArrayList values = new ArrayList();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)property, (associations, persistentProperty) -> values.add(new AbstractMap.SimpleEntry<PersistentProperty, Object>((PersistentProperty)persistentProperty, new PersistentPropertyPath(associations, property).getPropertyValue(value))));
        return values.stream();
    }

    protected final <E, R> SqlPreparedQuery<E, R> getSqlPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof SqlPreparedQuery) {
            SqlPreparedQuery sqlPreparedQuery = (SqlPreparedQuery)preparedQuery;
            return sqlPreparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: SqlPreparedQuery got: " + preparedQuery.getClass().getName());
    }

    protected final <E, R> SqlStoredQuery<E, R> getSqlStoredQuery(StoredQuery<E, R> storedQuery) {
        if (storedQuery instanceof SqlStoredQuery) {
            SqlStoredQuery sqlStoredQuery = (SqlStoredQuery)storedQuery;
            if (sqlStoredQuery.isExpandableQuery() && !(sqlStoredQuery instanceof SqlPreparedQuery)) {
                return new DefaultSqlPreparedQuery(sqlStoredQuery);
            }
            return sqlStoredQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: SqlStoredQuery got: " + storedQuery.getClass().getName());
    }

    protected boolean isSupportsBatchInsert(PersistentEntity persistentEntity, SqlStoredQuery<?, ?> sqlStoredQuery) {
        if (sqlStoredQuery.getOperationType() == StoredQuery.OperationType.INSERT_RETURNING) {
            return false;
        }
        return this.isSupportsBatchInsert(persistentEntity, sqlStoredQuery.getDialect());
    }

    protected boolean isSupportsBatchInsert(PersistentEntity persistentEntity, Dialect dialect) {
        return switch (dialect) {
            case Dialect.SQL_SERVER -> false;
            case Dialect.MYSQL, Dialect.ORACLE -> {
                if (persistentEntity.getIdentity() != null) {
                    if (!persistentEntity.getIdentity().isGenerated()) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            default -> true;
        };
    }

    protected boolean isSupportsBatchUpdate(PersistentEntity persistentEntity, SqlStoredQuery<?, ?> sqlStoredQuery) {
        return sqlStoredQuery.getOperationType() != StoredQuery.OperationType.UPDATE_RETURNING;
    }

    protected boolean isSupportsBatchDelete(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    protected final <T, R> SqlTypeMapper<RS, R> createQueryResultMapper(SqlStoredQuery<?, ?> sqlStoredQuery, String columnName, JsonDataType jsonDataType, Class<RS> resultSetType, RuntimePersistentEntity<T> persistentEntity, BiFunction<RuntimePersistentEntity<Object>, Object, Object> loadListener) {
        QueryResultInfo queryResultInfo = sqlStoredQuery.getQueryResultInfo();
        if (queryResultInfo != null && queryResultInfo.getType() != QueryResult.Type.JSON) {
            throw new IllegalStateException("Unexpected query result type: " + queryResultInfo.getType());
        }
        return this.createJsonQueryResultMapper(sqlStoredQuery, columnName, jsonDataType, resultSetType, persistentEntity, loadListener);
    }

    protected final boolean isJsonResult(StoredQuery<?, ?> preparedQuery, QueryResultInfo queryResultInfo) {
        if (preparedQuery.isCount()) {
            return false;
        }
        return queryResultInfo != null && queryResultInfo.getType() == QueryResult.Type.JSON;
    }

    protected final boolean isJsonEntityGeneratedId(StoredQuery<?, ?> storedQuery, PersistentEntity persistentEntity) {
        if (!storedQuery.isJsonEntity()) {
            return false;
        }
        PersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            return false;
        }
        return identity.getDataType().isNumeric();
    }

    protected final String getJsonColumn(QueryResultInfo queryResultInfo) {
        if (queryResultInfo != null) {
            return queryResultInfo.getColumnName();
        }
        return "DATA";
    }

    protected final JsonDataType getJsonDataType(QueryResultInfo queryResultInfo) {
        if (queryResultInfo != null) {
            return queryResultInfo.getJsonDataType();
        }
        return JsonDataType.DEFAULT;
    }

    private <T, R> JsonQueryResultMapper<T, RS, R> createJsonQueryResultMapper(SqlStoredQuery<?, ?> sqlStoredQuery, String columnName, JsonDataType jsonDataType, Class<RS> resultSetType, RuntimePersistentEntity<T> persistentEntity, BiFunction<RuntimePersistentEntity<Object>, Object, Object> loadListener) {
        return new JsonQueryResultMapper(columnName, jsonDataType, persistentEntity, this.columnNameResultSetReader, this.sqlJsonColumnMapperProvider.getJsonColumnReader(sqlStoredQuery, resultSetType), loadListener);
    }

    protected abstract Integer getFirstResultSetIndex();

    protected <E, R> SqlTypeMapper<RS, R> createMapper(final SqlStoredQuery<E, R> preparedQuery, Class<RS> rsType) {
        RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
        boolean isEntityResult = preparedQuery.getResultDataType() == DataType.ENTITY;
        BiFunction<RuntimePersistentEntity<Object>, Object, Object> loadListener = isEntityResult ? (loadedEntity, o) -> {
            if (loadedEntity.hasPostLoadEventListeners()) {
                return this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
            }
            return o;
        } : null;
        QueryResultInfo queryResultInfo = preparedQuery.getQueryResultInfo();
        if (this.isJsonResult(preparedQuery, queryResultInfo)) {
            String column = this.getJsonColumn(queryResultInfo);
            JsonDataType jsonDataType = this.getJsonDataType(queryResultInfo);
            return this.createQueryResultMapper(preparedQuery, column, jsonDataType, rsType, persistentEntity, loadListener);
        }
        if (isEntityResult || preparedQuery.isDtoProjection()) {
            Class resultType = preparedQuery.getResultType();
            Set joinPaths = preparedQuery.getJoinPaths();
            if (isEntityResult) {
                return new SqlResultEntityTypeMapper(this.getEntity(resultType), this.columnNameResultSetReader, joinPaths, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, rsType), loadListener, this.conversionService);
            }
            RuntimePersistentEntity resultPersistentEntity = this.getEntity(resultType);
            Collection beanProperties = resultPersistentEntity.getIntrospection().getBeanProperties();
            RuntimePersistentEntity dtoPersistentEntity = new RuntimePersistentEntity(resultPersistentEntity.getIntrospection(), beanProperties.stream().map(p -> {
                if (p.hasAnnotation(MappedProperty.class)) {
                    return p;
                }
                RuntimePersistentProperty entityProperty = persistentEntity.getPropertyByName(p.getName());
                if (entityProperty == null || !ReflectionUtils.getWrapperType((Class)entityProperty.getType()).equals(ReflectionUtils.getWrapperType((Class)p.getType()))) {
                    return p;
                }
                return new BeanPropertyWithAnnotationMetadata(p, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{p.getAnnotationMetadata(), entityProperty.getAnnotationMetadata()}));
            }).toList());
            return new SqlResultEntityTypeMapper(dtoPersistentEntity, this.columnNameResultSetReader, joinPaths, this.sqlJsonColumnMapperProvider.getJsonColumnReader(preparedQuery, rsType), null, this.conversionService);
        }
        return new SqlTypeMapper<RS, R>(){

            @Override
            public boolean hasNext(RS resultSet) {
                return AbstractSqlRepositoryOperations.this.columnIndexResultSetReader.next(resultSet);
            }

            @Override
            public R map(RS rs, Class<R> type) throws DataAccessException {
                Object v = AbstractSqlRepositoryOperations.this.columnIndexResultSetReader.readDynamic(rs, AbstractSqlRepositoryOperations.this.getFirstResultSetIndex(), preparedQuery.getResultDataType());
                if (v == null) {
                    return null;
                }
                if (type.isInstance(v)) {
                    return v;
                }
                return AbstractSqlRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, type);
            }

            @Override
            public Object read(RS object, String name) {
                throw new IllegalStateException("Not supported!");
            }
        };
    }

    @FunctionalInterface
    protected static interface StatementSupplier<PS> {
        public PS create(String var1) throws Exception;
    }

    private class QueryKey {
        final Class repositoryType;
        final Class entityType;

        QueryKey(Class repositoryType, Class entityType) {
            this.repositoryType = repositoryType;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryKey queryKey = (QueryKey)o;
            return this.repositoryType.equals(queryKey.repositoryType) && this.entityType.equals(queryKey.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryType, this.entityType);
        }
    }
}

