/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import java.util.List;

public abstract class DefaultAbstractFindPageInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected DefaultAbstractFindPageInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Class returnType = context.getReturnType().getType();
        if (context.hasAnnotation(Query.class)) {
            Page page;
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            Iterable iterable = this.operations.findAll(preparedQuery);
            List results = CollectionUtils.iterableToList((Iterable)iterable);
            Pageable pageable = this.getPageable(context);
            Long totalCount = null;
            if (pageable.requestTotal()) {
                PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
                Number n = (Number)this.operations.findOne(countQuery);
                Long l = totalCount = n != null ? Long.valueOf(n.longValue()) : null;
            }
            if (pageable.getMode() == Pageable.Mode.OFFSET) {
                page = Page.of((List)results, (Pageable)pageable, totalCount);
            } else if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                List<Pageable.Cursor> cursors = sqlPreparedQuery.createCursors(results, pageable);
                page = CursoredPage.of((List)results, (Pageable)pageable, cursors, (Long)totalCount);
            } else {
                throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
            }
            if (returnType.isInstance(page)) {
                return (R)page;
            }
            return (R)this.operations.getConversionService().convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
        }
        Page page = this.operations.findPage(this.getPagedQuery(context));
        if (returnType.isInstance(page)) {
            return (R)page;
        }
        return (R)this.operations.getConversionService().convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
    }
}

