/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.BlockingCriteriaCapableRepository;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.CriteriaDeleteBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaQueryBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaUpdateBuilder;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected final CriteriaRepositoryOperations criteriaRepositoryOperations;
    private final Map<RepositoryMethodKey, QueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, QueryBuilder>();
    private final Map<RepositoryMethodKey, Set<JoinPath>> methodsJoinPaths = new ConcurrentHashMap<RepositoryMethodKey, Set<JoinPath>>();
    private final CriteriaBuilder criteriaBuilder;
    private final MethodContextAwareStoredQueryDecorator storedQueryDecorator;
    private final PreparedQueryDecorator preparedQueryDecorator;

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (operations instanceof CriteriaRepositoryOperations) {
            CriteriaRepositoryOperations criteriaOps;
            this.criteriaRepositoryOperations = criteriaOps = (CriteriaRepositoryOperations)operations;
            this.criteriaBuilder = this.criteriaRepositoryOperations.getCriteriaBuilder();
        } else if (operations instanceof BlockingCriteriaCapableRepository) {
            BlockingCriteriaCapableRepository repository = (BlockingCriteriaCapableRepository)operations;
            this.criteriaRepositoryOperations = repository.blocking();
            this.criteriaBuilder = this.criteriaRepositoryOperations.getCriteriaBuilder();
        } else {
            this.criteriaRepositoryOperations = null;
            this.criteriaBuilder = (CriteriaBuilder)operations.getApplicationContext().getBean(RuntimeCriteriaBuilder.class);
        }
        if (operations instanceof MethodContextAwareStoredQueryDecorator) {
            this.storedQueryDecorator = (MethodContextAwareStoredQueryDecorator)operations;
        } else if (operations instanceof StoredQueryDecorator) {
            final StoredQueryDecorator decorator = (StoredQueryDecorator)operations;
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return decorator.decorate(storedQuery);
                }
            };
        } else {
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return storedQuery;
                }
            };
        }
        this.preparedQueryDecorator = operations instanceof PreparedQueryDecorator ? (PreparedQueryDecorator)operations : new PreparedQueryDecorator(){

            public <E, K> PreparedQuery<E, K> decorate(PreparedQuery<E, K> preparedQuery) {
                return preparedQuery;
            }
        };
    }

    @NonNull
    protected final Iterable<?> findAll(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.criteriaRepositoryOperations != null) {
            CriteriaQuery query = this.buildQuery(context, type, methodJoinPaths);
            Pageable pageable = this.getPageable(context);
            if (pageable != null) {
                return this.criteriaRepositoryOperations.findAll(query, (int)pageable.getOffset(), pageable.getSize());
            }
            return this.criteriaRepositoryOperations.findAll(query);
        }
        return this.operations.findAll(this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths));
    }

    @NonNull
    protected final Object findOne(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.criteriaRepositoryOperations != null) {
            return this.criteriaRepositoryOperations.findOne(this.buildQuery(context, type, methodJoinPaths));
        }
        return this.operations.findOne(this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths));
    }

    protected final Set<JoinPath> getMethodJoinPaths(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        return this.methodsJoinPaths.computeIfAbsent(methodKey, repositoryMethodKey -> AssociationUtils.getJoinFetchPaths((AnnotationMetadata)context));
    }

    @NonNull
    protected final Long count(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        Long count = this.criteriaRepositoryOperations != null ? (Long)this.criteriaRepositoryOperations.findOne(this.buildCountQuery(context)) : (Long)this.operations.findOne(this.preparedQueryForCriteria(methodKey, context, Type.COUNT, methodJoinPaths));
        return count == null ? 0L : count;
    }

    protected final boolean exists(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        boolean bl;
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.criteriaRepositoryOperations != null) {
            return (Boolean)this.criteriaRepositoryOperations.findOne(this.buildExistsQuery(context, methodJoinPaths));
        }
        Object one = this.operations.findOne(this.preparedQueryForCriteria(methodKey, context, Type.EXISTS, methodJoinPaths));
        if (one instanceof Boolean) {
            Boolean aBoolean = (Boolean)one;
            bl = aBoolean;
        } else {
            bl = one != null;
        }
        return bl;
    }

    protected final Optional<Number> deleteAll(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.criteriaRepositoryOperations != null) {
            return this.criteriaRepositoryOperations.deleteAll(this.buildDeleteQuery(context));
        }
        return this.operations.executeDelete(this.preparedQueryForCriteria(methodKey, context, Type.DELETE_ALL, methodJoinPaths));
    }

    protected final Optional<Number> updateAll(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.criteriaRepositoryOperations != null) {
            return this.criteriaRepositoryOperations.updateAll(this.buildUpdateQuery(context));
        }
        return this.operations.executeUpdate(this.preparedQueryForCriteria(methodKey, context, Type.UPDATE_ALL, methodJoinPaths));
    }

    @NonNull
    protected final <E, QR> PreparedQuery<E, QR> preparedQueryForCriteria(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type, Set<JoinPath> methodJoinPaths) {
        Object storedQuery;
        Pageable pageable = this.findPageable(context);
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        if (type == Type.FIND_ALL || type == Type.FIND_ONE || type == Type.FIND_PAGE) {
            storedQuery = this.buildFind(methodKey, context, type, methodJoinPaths);
        } else if (type == Type.COUNT) {
            storedQuery = this.buildCount(methodKey, context);
        } else if (type == Type.DELETE_ALL) {
            storedQuery = this.buildDeleteAll(context, sqlQueryBuilder);
        } else if (type == Type.UPDATE_ALL) {
            storedQuery = this.buildUpdateAll(context, sqlQueryBuilder);
        } else if (type == Type.EXISTS) {
            storedQuery = this.buildExists(context, sqlQueryBuilder, methodJoinPaths);
        } else {
            throw new IllegalStateException("Unknown criteria type: " + type);
        }
        storedQuery = this.storedQueryDecorator.decorate(context, storedQuery);
        PreparedQuery<E, Object> preparedQuery = this.preparedQueryResolver.resolveQuery(context, storedQuery, pageable);
        return this.preparedQueryDecorator.decorate(preparedQuery);
    }

    @NonNull
    private Pageable findPageable(MethodInvocationContext<T, R> context) {
        Pageable pageable = Pageable.UNPAGED;
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Pageable)) continue;
            pageable = (Pageable)param;
            break;
        }
        return pageable;
    }

    @NonNull
    private QueryBuilder getQueryBuilder(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        return this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> {
            Class builder = (Class)context.getAnnotationMetadata().classValue(RepositoryConfiguration.class, "queryBuilder").orElseThrow(() -> new IllegalStateException("Cannot determine QueryBuilder"));
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)builder);
            if (introspection.getConstructorArguments().length == 1 && introspection.getConstructorArguments()[0].getType() == AnnotationMetadata.class) {
                return (QueryBuilder)introspection.instantiate(new Object[]{context.getAnnotationMetadata()});
            }
            return (QueryBuilder)introspection.instantiate();
        });
    }

    private <E> StoredQuery<E, ?> buildExists(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder, Set<JoinPath> annotationJoinPaths) {
        CriteriaQuery<E> criteriaQuery = this.buildExistsQuery(context, annotationJoinPaths);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.EXISTS, context.getName(), context.getAnnotationMetadata(), queryResult, this.getRequiredRootEntity(context));
    }

    protected final <E> CriteriaQuery<E> buildExistsQuery(MethodInvocationContext<T, R> context, Set<JoinPath> annotationJoinPaths) {
        return this.getCriteriaQueryBuilder(context, annotationJoinPaths).build(this.criteriaBuilder);
    }

    private <E> StoredQuery<E, ?> buildUpdateAll(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder) {
        CriteriaUpdate<E> criteriaUpdate = this.buildUpdateQuery(context);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaUpdate).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.UPDATE, context.getName(), context.getAnnotationMetadata(), queryResult, criteriaUpdate.getRoot().getJavaType());
    }

    protected final <E> CriteriaUpdate<E> buildUpdateQuery(MethodInvocationContext<T, R> context) {
        return this.getCriteriaUpdateBuilder(context).build(this.criteriaBuilder);
    }

    private <E> StoredQuery<E, ?> buildDeleteAll(MethodInvocationContext<T, R> context, QueryBuilder sqlQueryBuilder) {
        CriteriaDelete<E> criteriaDelete = this.buildDeleteQuery(context);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaDelete).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.DELETE, context.getName(), context.getAnnotationMetadata(), queryResult, criteriaDelete.getRoot().getJavaType());
    }

    protected final <E> CriteriaDelete<E> buildDeleteQuery(MethodInvocationContext<T, R> context) {
        return this.getCriteriaDeleteBuilder(context).build(this.criteriaBuilder);
    }

    private <E> StoredQuery<E, ?> buildCount(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        CriteriaQuery<Long> criteriaQuery = this.buildCountQuery(context);
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(sqlQueryBuilder);
        return QueryResultStoredQuery.count(context.getName(), context.getAnnotationMetadata(), queryResult, this.getRequiredRootEntity(context));
    }

    @NonNull
    protected final <E> CriteriaQuery<Long> buildCountQuery(MethodInvocationContext<T, R> context) {
        Predicate predicate;
        Class rootEntity = this.getRequiredRootEntity(context);
        QuerySpecification specification = this.getQuerySpecification(context);
        CriteriaQuery criteriaQuery = this.criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(rootEntity);
        if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, this.criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        if (criteriaQuery.isDistinct()) {
            return criteriaQuery.select((Selection)this.criteriaBuilder.countDistinct((Expression)root));
        }
        return criteriaQuery.select((Selection)this.criteriaBuilder.count((Expression)root));
    }

    private <E> StoredQuery<E, Object> buildFind(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type, Set<JoinPath> methodJoinPaths) {
        CriteriaQuery criteriaQuery = this.buildInternalQuery(context, type, methodJoinPaths);
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        QueryResultPersistentEntityCriteriaQuery queryModelCriteriaQuery = (QueryResultPersistentEntityCriteriaQuery)criteriaQuery;
        QueryModel queryModel = queryModelCriteriaQuery.getQueryModel();
        Collection queryJoinPaths = queryModel.getJoinPaths();
        QueryResult queryResult = sqlQueryBuilder.buildQuery(AnnotationMetadata.EMPTY_METADATA, queryModel);
        Set<JoinPath> joinPaths = this.mergeJoinPaths(methodJoinPaths, queryJoinPaths).stream().filter(jp -> jp.getJoinType().isFetch()).collect(Collectors.toSet());
        Class rootEntity = this.getRequiredRootEntity(context);
        if (type == Type.FIND_ONE) {
            return QueryResultStoredQuery.single(StoredQuery.OperationType.QUERY, context.getName(), context.getAnnotationMetadata(), queryResult, rootEntity, criteriaQuery.getResultType(), joinPaths);
        }
        Pageable pageable = this.findPageable(context);
        return QueryResultStoredQuery.many(context.getName(), context.getAnnotationMetadata(), queryResult, rootEntity, criteriaQuery.getResultType(), !pageable.isUnpaged(), joinPaths);
    }

    private <N> CriteriaQuery<N> buildInternalQuery(MethodInvocationContext<T, R> context, Type type, Set<JoinPath> methodJoinPaths) {
        CriteriaQueryBuilder builder = this.getCriteriaQueryBuilder(context, methodJoinPaths);
        CriteriaQuery criteriaQuery = builder.build(this.criteriaBuilder);
        if (type == Type.FIND_ALL) {
            Pageable pageable = this.findPageable(context);
            for (Object param : context.getParameterValues()) {
                if (!(param instanceof Sort)) continue;
                Sort sort = (Sort)param;
                if (param == pageable || !sort.isSorted()) continue;
                Root root = (Root)criteriaQuery.getRoots().stream().findFirst().orElseThrow(() -> new IllegalStateException("The root not found!"));
                criteriaQuery.orderBy(this.getOrders(sort, root, this.criteriaBuilder));
                break;
            }
        }
        return criteriaQuery;
    }

    protected final <N> CriteriaQuery<N> buildQuery(MethodInvocationContext<T, R> context, Type type, Set<JoinPath> methodJoinPaths) {
        CriteriaQueryBuilder builder = this.getCriteriaQueryBuilder(context, methodJoinPaths);
        CriteriaQuery criteriaQuery = builder.build(this.criteriaBuilder);
        for (Object param : context.getParameterValues()) {
            Sort sort;
            if (!(param instanceof Sort) || !(sort = (Sort)param).isSorted()) continue;
            Root root = (Root)criteriaQuery.getRoots().stream().findFirst().orElseThrow(() -> new IllegalStateException("The root not found!"));
            criteriaQuery.orderBy(this.getOrders(sort, root, this.criteriaBuilder));
            break;
        }
        return criteriaQuery;
    }

    @Nullable
    protected <K> QuerySpecification<K> getQuerySpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof QuerySpecification) {
            return (QuerySpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return QuerySpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(QuerySpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + QuerySpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaQueryBuilder<K> getCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaQueryBuilder) {
            return (CriteriaQueryBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            QuerySpecification specification = this.getQuerySpecification(context);
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(rootEntity);
            Root root = criteriaQuery.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            if (CollectionUtils.isNotEmpty((Collection)joinPaths)) {
                for (JoinPath joinPath : joinPaths) {
                    this.join(root, joinPath);
                }
            }
            return criteriaQuery;
        };
    }

    private void join(Root<?> root, JoinPath joinPath) {
        if (root instanceof PersistentEntityFrom) {
            PersistentEntityFrom persistentEntityFrom = (PersistentEntityFrom)root;
            Optional optAlias = joinPath.getAlias();
            if (optAlias.isPresent()) {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType(), (String)optAlias.get());
            } else {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType());
            }
        }
    }

    private Set<JoinPath> mergeJoinPaths(Set<JoinPath> joinPaths, Collection<JoinPath> additionalJoinPaths) {
        HashSet<JoinPath> resultPaths = new HashSet<JoinPath>(5);
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            resultPaths.addAll(joinPaths);
        }
        if (CollectionUtils.isNotEmpty(additionalJoinPaths)) {
            Map existingPathsByPath = resultPaths.stream().collect(Collectors.toMap(JoinPath::getPath, Function.identity()));
            resultPaths.addAll(additionalJoinPaths.stream().filter(jp -> !existingPathsByPath.containsKey(jp.getPath())).collect(Collectors.toSet()));
        }
        return resultPaths;
    }

    @Nullable
    protected <K> DeleteSpecification<K> getDeleteSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof DeleteSpecification) {
            return (DeleteSpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return DeleteSpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(DeleteSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + DeleteSpecification.class + " or " + PredicateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaDeleteBuilder<K> getCriteriaDeleteBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaDeleteBuilder) {
            return (CriteriaDeleteBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            DeleteSpecification specification = this.getDeleteSpecification(context);
            CriteriaDelete criteriaDelete = criteriaBuilder.createCriteriaDelete(rootEntity);
            Root root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaDelete, criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            return criteriaDelete;
        };
    }

    @Nullable
    protected <K> UpdateSpecification<K> getUpdateSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof UpdateSpecification) {
            return (UpdateSpecification)parameterValue;
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(UpdateSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + UpdateSpecification.class);
    }

    @NonNull
    protected <K> CriteriaUpdateBuilder<K> getCriteriaUpdateBuilder(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof CriteriaUpdateBuilder) {
            return (CriteriaUpdateBuilder)parameterValue;
        }
        return criteriaBuilder -> {
            Predicate predicate;
            Class rootEntity = this.getRequiredRootEntity(context);
            UpdateSpecification specification = this.getUpdateSpecification(context);
            CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(rootEntity);
            Root root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaUpdate, criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            return criteriaUpdate;
        };
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root.get(order.getProperty());
            orders.add(order.isAscending() ? cb.asc((Expression)propertyPath) : cb.desc((Expression)propertyPath));
        }
        return orders;
    }

    protected static enum Type {
        COUNT,
        FIND_ONE,
        FIND_PAGE,
        FIND_ALL,
        DELETE_ALL,
        UPDATE_ALL,
        EXISTS;

    }
}

