/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.concurrent.CompletionStage;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractAsyncInterceptor2<T, R>
extends AbstractQueryInterceptor<T, CompletionStage<? extends R>> {
    @NonNull
    protected final AsyncRepositoryOperations asyncDatastoreOperations;

    protected AbstractAsyncInterceptor2(@NonNull RepositoryOperations datastore) {
        super(datastore);
        if (!(datastore instanceof AsyncCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + datastore.getClass() + "] does not support asynchronous operations");
        }
        this.asyncDatastoreOperations = ((AsyncCapableRepository)datastore).async();
    }

    @Override
    protected final Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return this.findReturnType(context, Argument.OBJECT_ARGUMENT);
    }

    protected final Argument<?> findReturnType(MethodInvocationContext<?, ?> context, Argument<?> defaultArg) {
        if (context.isSuspend()) {
            return context.getReturnType().asArgument();
        }
        return context.getReturnType().asArgument().getFirstTypeVariable().orElse(defaultArg);
    }
}

