/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;

public abstract class DefaultAbstractFindPageInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected DefaultAbstractFindPageInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Class returnType = context.getReturnType().getType();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            Page page = this.operations.findPage(preparedQuery);
            if (!page.hasTotalSize() && preparedQuery.getPageable().requestTotal()) {
                PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
                Number n = (Number)this.operations.findOne(countQuery);
                Long totalCount = n != null ? n.longValue() : -1L;
                if (page instanceof CursoredPage) {
                    CursoredPage cursoredPage = (CursoredPage)page;
                    page = CursoredPage.of((List)cursoredPage.getContent(), (Pageable)cursoredPage.getPageable(), (List)cursoredPage.getCursors(), (Long)totalCount);
                } else {
                    page = Page.of((List)page.getContent(), (Pageable)page.getPageable(), (Long)totalCount);
                }
            }
            if (returnType.isInstance(page)) {
                return (R)page;
            }
            return (R)this.operations.getConversionService().convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
        }
        Page page = this.operations.findPage(this.getPagedQuery(context));
        if (returnType.isInstance(page)) {
            return (R)page;
        }
        return (R)this.operations.getConversionService().convert((Object)page, returnType).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + returnType));
    }
}

