/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.exceptions.jakarta.data;

import io.micronaut.context.annotation.Requires;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataDeleteExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataInsertExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataUpdateExceptionConverter;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Singleton;

@Singleton
@Requires(classes={OptimisticLockingFailureException.class})
final class MicronautDataJakartaDataExceptionConverter
implements JakartaDataExceptionConverter,
JakartaDataUpdateExceptionConverter,
JakartaDataDeleteExceptionConverter,
JakartaDataInsertExceptionConverter {
    MicronautDataJakartaDataExceptionConverter() {
    }

    public Exception convert(Exception exception) {
        if (exception instanceof OptimisticLockException) {
            throw new OptimisticLockingFailureException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof NonUniqueResultException) {
            throw new jakarta.data.exceptions.NonUniqueResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof EmptyResultException) {
            throw new jakarta.data.exceptions.EmptyResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof MappingException) {
            return new DataException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof DataAccessException) {
            DataAccessException e = (DataAccessException)exception;
            if (e.getMessage().contains("Unique index or primary key violation")) {
                throw new EntityExistsException(exception.getMessage(), (Throwable)exception);
            }
            return new DataException(exception.getMessage(), (Throwable)exception);
        }
        return exception;
    }
}

