/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.json.JsonMapper;
import java.io.IOException;

public interface JsonColumnReader<S> {
    public static final String NULL_VALUE = "null";

    default public <T> T readJsonColumn(ResultReader<S, String> resultReader, S resultSet, String columnName, JsonDataType jsonDataType, Argument<T> argument) {
        String data = resultReader.readString(resultSet, columnName);
        if (StringUtils.isEmpty((CharSequence)data) || data.equals(NULL_VALUE)) {
            return null;
        }
        if (argument.getType().equals(String.class)) {
            return (T)data;
        }
        try {
            return (T)this.getJsonMapper().readValue(data, argument);
        }
        catch (IOException e) {
            throw new DataAccessException("Failed to read from JSON field [" + columnName + "].", (Throwable)e);
        }
    }

    @NonNull
    public JsonMapper getJsonMapper();
}

