/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.reactive.AbstractReactiveSpecificationInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class FindPageReactiveSpecificationInterceptor
extends AbstractReactiveSpecificationInterceptor<Object, Object> {
    protected FindPageReactiveSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Mono result;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            Flux results = Flux.from(this.findAllReactive(methodKey, context));
            result = results.collectList().map(resultList -> Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size())));
        } else {
            Flux content;
            CriteriaQuery criteriaQuery = this.buildQuery(methodKey, context);
            Root root = (Root)criteriaQuery.getRoots().iterator().next();
            if (root.getJoins().isEmpty()) {
                content = this.findAllReactive(methodKey, context, pageable, criteriaQuery);
            } else {
                CriteriaQuery<Tuple> criteriaIdsQuery = this.buildIdsQuery(methodKey, context, (Sort)pageable);
                content = this.findAllReactive(methodKey, context, pageable, criteriaIdsQuery).collectList().flatMapMany(tupleResult -> {
                    if (tupleResult.isEmpty()) {
                        return Flux.empty();
                    }
                    ArrayList<Object> ids = new ArrayList<Object>(tupleResult.size());
                    for (Tuple tuple : tupleResult) {
                        ids.add(tuple.get(0));
                    }
                    Predicate inPredicate = this.getIdExpression(root).in(ids);
                    criteriaQuery.where((Expression)inPredicate);
                    return this.findAllReactive(methodKey, context, pageable.withoutPaging(), criteriaQuery);
                });
            }
            result = content.collectList().flatMap(list -> {
                if (pageable.requestTotal()) {
                    return Mono.from((Publisher)this.getReactiveCriteriaOperations(methodKey, context, null).findOne(this.buildCountQuery(methodKey, context))).map(count -> this.getPage((List<Object>)list, pageable, (Long)count, context));
                }
                return Mono.just(this.getPage((List<Object>)list, pageable, null, context));
            });
        }
        return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)result, (Class)context.getReturnType().getType());
    }

    private Page<?> getPage(List<Object> list, Pageable pageable, Long count, MethodInvocationContext<Object, Object> context) {
        Page page;
        if (pageable.getMode() == Pageable.Mode.OFFSET) {
            page = Page.of(list, (Pageable)pageable, (Long)count);
        } else {
            PreparedQuery preparedQuery = context.getAttribute((CharSequence)"PREPARED_QUERY").orElse(null);
            if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                List<Pageable.Cursor> cursors = sqlPreparedQuery.createCursors(list, pageable);
                page = CursoredPage.of(list, (Pageable)pageable, cursors, (Long)count);
            } else {
                throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
            }
        }
        return page;
    }

    private <T> Flux<T> findAllReactive(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable, CriteriaQuery<T> criteriaQuery) {
        pageable = this.applyPaginationAndSort(pageable, criteriaQuery, false);
        if (this.reactiveCriteriaOperations != null) {
            if (pageable != null) {
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + pageable.getMode() + " is not supported by hibernate operations");
                }
                return Flux.from((Publisher)this.reactiveCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize()));
            }
            int offset = this.getOffset(context);
            int limit = this.getLimit(context);
            if (offset > 0 || limit > 0) {
                return Flux.from((Publisher)this.reactiveCriteriaOperations.findAll(criteriaQuery, offset, limit));
            }
            return Flux.from((Publisher)this.reactiveCriteriaOperations.findAll(criteriaQuery));
        }
        return Flux.from((Publisher)this.getReactiveCriteriaOperations(methodKey, context, pageable).findAll(criteriaQuery));
    }
}

