/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder2;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.QueryResultInfo;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.DummyPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.query.internal.DefaultPreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegatePreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public class DefaultSqlPreparedQuery<E, R>
extends DefaultBindableParametersPreparedQuery<E, R>
implements SqlPreparedQuery<E, R>,
DelegatePreparedQuery<E, R> {
    protected List<QueryParameterBinding> cursorQueryBindings;
    protected List<PersistentPropertyPath> cursorProperties;
    protected final SqlStoredQuery<E, R> sqlStoredQuery;
    protected String query;
    private final boolean bindPageableOrSort;

    public DefaultSqlPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        this(preparedQuery, (SqlStoredQuery)((DelegateStoredQuery)preparedQuery).getStoredQueryDelegate());
    }

    public DefaultSqlPreparedQuery(PreparedQuery<E, R> preparedQuery, SqlStoredQuery<E, R> sqlStoredQuery) {
        super(preparedQuery);
        this.sqlStoredQuery = sqlStoredQuery;
        this.query = sqlStoredQuery.getQuery();
        this.bindPageableOrSort = this.getQueryBindings().stream().anyMatch(p -> "pageable".equals(p.getRole()) || "sort".equals(p.getRole()));
    }

    public DefaultSqlPreparedQuery(SqlStoredQuery<E, R> sqlStoredQuery) {
        super(new DummyPreparedQuery<E, R>(sqlStoredQuery), null, sqlStoredQuery);
        this.sqlStoredQuery = sqlStoredQuery;
        this.query = sqlStoredQuery.getQuery();
        this.bindPageableOrSort = this.getQueryBindings().stream().anyMatch(p -> "pageable".equals(p.getRole()) || "sort".equals(p.getRole()));
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.sqlStoredQuery.getPersistentEntity();
    }

    @Override
    public PreparedQuery<E, R> getPreparedQueryDelegate() {
        return this.preparedQuery;
    }

    @Override
    public boolean isExpandableQuery() {
        return this.sqlStoredQuery.isExpandableQuery();
    }

    @Override
    public Dialect getDialect() {
        return this.sqlStoredQuery.getDialect();
    }

    @Override
    public SqlQueryBuilder2 getQueryBuilder() {
        return this.sqlStoredQuery.getQueryBuilder();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(E entity) {
        return this.sqlStoredQuery.collectAutoPopulatedPreviousValues(entity);
    }

    @Override
    public void prepare(E entity) {
        if (this.isExpandableQuery()) {
            SqlQueryBuilder2 queryBuilder = this.sqlStoredQuery.getQueryBuilder();
            String positionalParameterFormat = queryBuilder.positionalParameterFormat();
            StringBuilder q = new StringBuilder(this.sqlStoredQuery.getExpandableQueryParts()[0]);
            int queryParamIndex = 1;
            int inx = 1;
            for (QueryParameterBinding parameter : this.sqlStoredQuery.getQueryBindings()) {
                if (!parameter.isExpandable()) {
                    q.append(String.format(positionalParameterFormat, inx++));
                } else if (parameter.getRole() == null) {
                    Object parameterValue = this.getParameterValue(parameter);
                    int size = Math.max(1, this.sizeOf(parameterValue));
                    for (int k = 0; k < size; ++k) {
                        q.append(String.format(positionalParameterFormat, inx++));
                        if (k + 1 == size) continue;
                        q.append(",");
                    }
                } else if ("pageableRequired".equals(parameter.getRole())) {
                    pageable = this.getPageableParameter(parameter);
                    if (!pageable.isUnpaged()) {
                        this.appendPageable(q, pageable, pageable.getLimit(), pageable.getSort(), parameter.getTableAlias(), inx);
                    }
                } else if ("pageable".equals(parameter.getRole())) {
                    pageable = this.getPageableParameter(parameter);
                    this.appendPageable(q, pageable, pageable.getLimit(), pageable.getSort(), parameter.getTableAlias(), inx);
                } else if ("sort".equals(parameter.getRole())) {
                    sort = this.getSortParameter(parameter);
                    this.appendSort(sort, q, this.sqlStoredQuery.getQueryBuilder(), parameter.getTableAlias());
                    Limit limit = this.sqlStoredQuery.getQueryLimit();
                    if (!limit.isLimited()) {
                        limit = this.getParameterInRole("querylimit", Limit.class).orElse(limit);
                    }
                    if (limit.isLimited()) {
                        q.append(queryBuilder.buildLimitAndOffset((long)limit.maxResults(), limit.offset()));
                    }
                } else if ("querylimit".equals(parameter.getRole())) {
                    Limit limit;
                    sort = this.storedQuery.getSort();
                    if (sort.isSorted()) {
                        this.appendSort(sort, q, this.sqlStoredQuery.getQueryBuilder(), parameter.getTableAlias());
                    }
                    if ((limit = this.getLimitParameter(parameter)).isLimited()) {
                        q.append(queryBuilder.buildLimitAndOffset((long)limit.maxResults(), limit.offset()));
                    }
                }
                q.append(this.sqlStoredQuery.getExpandableQueryParts()[queryParamIndex++]);
            }
            this.query = q.toString();
        }
    }

    private Pageable getPageableParameter(QueryParameterBinding parameter) {
        Sort storedSort;
        Object value = this.getParameterValue(parameter);
        Pageable pageable = (Pageable)this.getConversionService().convert(value, Pageable.class).orElseThrow(() -> new IllegalArgumentException("Unsupported parameter type " + parameter.getRole()));
        if (pageable.getMode() == Pageable.Mode.OFFSET && DefaultPreparedQuery.hasReturnTypeInRole("cursoredPage", CursoredPage.class, this.invocationContext, this.getConversionService())) {
            if (pageable.getNumber() == 0) {
                pageable = CursoredPageable.from((int)pageable.getSize(), (Sort)pageable.getSort());
            } else {
                throw new IllegalArgumentException("Pageable with offset mode provided, but method must return a cursored page");
            }
        }
        if ((storedSort = this.storedQuery.getSort()).isSorted()) {
            pageable = pageable.withSort(storedSort.orders(pageable.getOrderBy()));
        }
        for (Sort sort : this.getParametersInRole("sort", Sort.class)) {
            if (sort == pageable) continue;
            pageable = pageable.withSort(pageable.getSort().orders(sort.getOrderBy()));
        }
        return pageable;
    }

    private Sort getSortParameter(QueryParameterBinding parameter) {
        Object value = this.getParameterValue(parameter);
        Sort sort = (Sort)this.getConversionService().convert(value, Sort.class).orElseThrow(() -> new IllegalArgumentException("Unsupported parameter type " + parameter.getRole()));
        Sort querySort = this.storedQuery.getSort();
        if (querySort.isSorted()) {
            sort = querySort.orders(sort.getOrderBy());
        }
        for (Object itemValue : this.getParametersInRole("sort", Object.class)) {
            Sort sortItem;
            if (itemValue == value || (sortItem = (Sort)this.getConversionService().convert(itemValue, Sort.class).orElse(null)) == null) continue;
            sort = sort.orders(sortItem.getOrderBy());
        }
        return sort;
    }

    private Limit getLimitParameter(QueryParameterBinding parameter) {
        Object value = this.getParameterValue(parameter);
        return (Limit)this.getConversionService().convert(value, Limit.class).orElseThrow(() -> new IllegalArgumentException("Unsupported parameter type " + parameter.getRole()));
    }

    protected int getQueryParameterValueSize(QueryParameterBinding parameter) {
        Object value = this.getParameterValue(parameter);
        return this.sizeOf(value);
    }

    private Object getParameterValue(QueryParameterBinding parameter) {
        int parameterIndex = parameter.getParameterIndex();
        Object value = parameterIndex == -1 ? parameter.getValue() : this.preparedQuery.getParameterArray()[parameterIndex];
        return value;
    }

    public static Sort enhanceCursoredSort(Sort sort, boolean isBackwards, PersistentEntity persistentEntity) {
        ArrayList orders = new ArrayList(sort.getOrderBy());
        for (PersistentProperty idProperty : persistentEntity.getIdentityProperties()) {
            PersistentEntityUtils.traversePersistentProperties((PersistentProperty)idProperty, (associations, property) -> {
                String name;
                String prefix = String.join((CharSequence)".", associations.stream().map(PersistentProperty::getName).toList());
                String propertyName = property.getName();
                String string = name = StringUtils.isEmpty((CharSequence)prefix) ? propertyName : prefix + "." + propertyName;
                if (orders.stream().noneMatch(o -> o.getProperty().equals(name))) {
                    orders.add(Sort.Order.asc((String)name));
                }
            });
        }
        sort = Sort.of(orders);
        if (isBackwards) {
            return DefaultSqlPreparedQuery.reverseSort(sort);
        }
        return sort;
    }

    public static CursoredPageable enhancePageable(CursoredPageable cursored, PersistentEntity persistentEntity) {
        return cursored.withSort(DefaultSqlPreparedQuery.enhanceCursoredSort(cursored.getSort(), cursored.isBackward(), persistentEntity));
    }

    @Override
    public void attachPageable(Pageable pageable, Limit limit, Sort sort) {
        if (pageable.isUnpaged() && !pageable.isSorted() || this.bindPageableOrSort) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.appendPageable(builder, pageable, limit, sort, null, this.storedQuery.getQueryBindings().size() + 1);
        int forUpdateIndex = this.query.lastIndexOf(" FOR UPDATE");
        if (forUpdateIndex == -1) {
            forUpdateIndex = this.query.lastIndexOf(" WITH (UPDLOCK, ROWLOCK)");
        }
        this.query = forUpdateIndex > -1 ? this.query.substring(0, forUpdateIndex) + String.valueOf(builder) + this.query.substring(forUpdateIndex) : this.query + String.valueOf(builder);
    }

    private void appendPageable(StringBuilder query, Pageable pageable, Limit limit, Sort sort, String tableAlias, int paramIndex) {
        SqlQueryBuilder2 queryBuilder = this.sqlStoredQuery.getQueryBuilder();
        if (pageable instanceof CursoredPageable) {
            CursoredPageable cursored = (CursoredPageable)pageable;
            cursored = DefaultSqlPreparedQuery.enhancePageable(cursored, this.getPersistentEntity());
            query.append(this.buildCursorPagination(cursored, paramIndex, tableAlias));
            this.appendSort(cursored.getSort(), query, queryBuilder, tableAlias);
            query.append(queryBuilder.buildLimitAndOffset((long)cursored.getSize(), 0L));
        } else {
            this.appendLimitOrOrderQueryPart(query, limit, sort, tableAlias);
        }
    }

    private void appendLimitOrOrderQueryPart(StringBuilder query, Limit limit, Sort sort, String tableAlias) {
        SqlQueryBuilder2 queryBuilder = this.sqlStoredQuery.getQueryBuilder();
        this.appendSort(sort, query, queryBuilder, tableAlias);
        query.append(queryBuilder.buildLimitAndOffset((long)limit.maxResults(), limit.offset()));
    }

    private void appendSort(Sort sort, StringBuilder added, SqlQueryBuilder2 queryBuilder, String tableAlias) {
        RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
        if (sort.isSorted()) {
            added.append(queryBuilder.buildOrderBy("", persistentEntity, this.sqlStoredQuery.getAnnotationMetadata(), sort, this.isNative(), tableAlias));
        } else if (this.isSqlServerWithoutOrderBy(this.query, this.sqlStoredQuery.getDialect())) {
            sort = this.sortById(persistentEntity);
            added.append(queryBuilder.buildOrderBy("", persistentEntity, this.sqlStoredQuery.getAnnotationMetadata(), sort, this.isNative(), tableAlias));
        }
    }

    private static Sort reverseSort(Sort sort) {
        if (!sort.isSorted()) {
            return sort;
        }
        return Sort.of(sort.getOrderBy().stream().map(Sort.Order::reverse).toList());
    }

    @NonNull
    private String buildCursorPagination(@NonNull CursoredPageable cursoredPageable, int paramIndex, @Nullable String tableAlias) {
        RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
        List<PersistentPropertyPath> cursorPersistentPropertyPaths = this.getCursorProperties(cursoredPageable, persistentEntity);
        Optional optionalCursor = cursoredPageable.cursor();
        if (optionalCursor.isEmpty()) {
            return "";
        }
        Pageable.Cursor cursor = (Pageable.Cursor)optionalCursor.get();
        List orders = cursoredPageable.getSort().getOrderBy();
        if (orders.size() != cursor.size()) {
            throw new IllegalArgumentException("The cursor must match the sorting size");
        }
        if (orders.isEmpty()) {
            throw new IllegalArgumentException("At least one sorting property must be supplied");
        }
        ArrayList<CursoredQueryParameterBinder> cursorBindings = new ArrayList<CursoredQueryParameterBinder>(orders.size());
        this.cursorQueryBindings = new ArrayList<QueryParameterBinding>(orders.size() * (orders.size() + 1) / 2);
        for (int i = 0; i < orders.size(); ++i) {
            cursorBindings.add(new CursoredQueryParameterBinder("cursor_" + i, cursorPersistentPropertyPaths.get(i).getProperty().getDataType(), cursor.get(i)));
        }
        StringBuilder builder = new StringBuilder(" ");
        if (this.query.contains("WHERE")) {
            int i = this.query.indexOf("WHERE") + "WHERE".length();
            this.query = this.query.substring(0, i) + "(" + this.query.substring(i) + ")";
            builder.append(" AND (");
        } else {
            builder.append("WHERE (");
        }
        String positionalParameter = this.getQueryBuilder().positionalParameterFormat();
        for (int i = 0; i < orders.size(); ++i) {
            builder.append("(");
            for (int j = 0; j <= i; ++j) {
                String propertyName = ((Sort.Order)orders.get(j)).getProperty();
                builder.append(this.sqlStoredQuery.getQueryBuilder().buildPropertyByName(propertyName, this.query, persistentEntity, this.getAnnotationMetadata(), this.isNative(), tableAlias));
                if (((Sort.Order)orders.get(i)).isAscending()) {
                    builder.append(i == j ? " > " : " = ");
                } else {
                    builder.append(i == j ? " < " : " = ");
                }
                this.cursorQueryBindings.add((QueryParameterBinding)cursorBindings.get(j));
                builder.append(String.format(positionalParameter, paramIndex++));
                if (i == j) continue;
                builder.append(" AND ");
            }
            builder.append(")");
            if (i >= orders.size() - 1) continue;
            builder.append(" OR ");
        }
        builder.append(")");
        return builder.toString();
    }

    private List<PersistentPropertyPath> getCursorProperties(CursoredPageable cursoredPageable, RuntimePersistentEntity<Object> persistentEntity) {
        if (this.cursorProperties == null) {
            Sort sort = cursoredPageable.getSort();
            this.cursorProperties = new ArrayList<PersistentPropertyPath>(sort.getOrderBy().size());
            for (Sort.Order order : sort.getOrderBy()) {
                this.cursorProperties.add(persistentEntity.getPropertyPath(order.getProperty()));
            }
        }
        return this.cursorProperties;
    }

    @Internal
    public List<Pageable.Cursor> createCursors(List<Object> results, Pageable pageable) {
        return this.createCursors(results, pageable, this.getPersistentEntity());
    }

    @Internal
    public List<Pageable.Cursor> createCursors(List<Object> results, Pageable pageable, RuntimePersistentEntity<Object> runtimePersistentEntity) {
        if (pageable.getMode() != Pageable.Mode.CURSOR_NEXT && pageable.getMode() != Pageable.Mode.CURSOR_PREVIOUS) {
            return null;
        }
        if (CollectionUtils.isEmpty(results)) {
            return List.of();
        }
        if (pageable.getMode() == Pageable.Mode.CURSOR_PREVIOUS) {
            Collections.reverse(results);
        }
        CursoredPageable cursoredPageable = DefaultSqlPreparedQuery.enhancePageable((CursoredPageable)pageable, runtimePersistentEntity);
        List<PersistentPropertyPath> cursorPersistentPropertyPaths = this.getCursorProperties(cursoredPageable, runtimePersistentEntity);
        ArrayList<Pageable.Cursor> cursors = new ArrayList<Pageable.Cursor>(results.size());
        boolean isDto = this.preparedQuery.isDtoProjection();
        for (Object result : results) {
            ArrayList<Object> cursorElements = new ArrayList<Object>(cursorPersistentPropertyPaths.size());
            for (PersistentPropertyPath property : cursorPersistentPropertyPaths) {
                if (isDto) {
                    PersistentPropertyPath dtoProperty = runtimePersistentEntity.getPropertyPath(property.getPath());
                    if (dtoProperty == null) {
                        throw new IllegalStateException("DTO projection " + String.valueOf(runtimePersistentEntity) + " must contain property " + property.getPath());
                    }
                    cursorElements.add(dtoProperty.getPropertyValue(result));
                    continue;
                }
                cursorElements.add(property.getPropertyValue(result));
            }
            cursors.add(Pageable.Cursor.of(cursorElements));
        }
        return cursors;
    }

    @Override
    public void bindParameters(BindableParametersStoredQuery.Binder binder, E entity, Map<QueryParameterBinding, Object> previousValues) {
        super.bindParameters(binder, entity, previousValues);
        if (this.cursorQueryBindings != null) {
            for (QueryParameterBinding queryParameterBinding : this.cursorQueryBindings) {
                binder.bindOne(queryParameterBinding, queryParameterBinding.getValue());
            }
        }
    }

    @Override
    public QueryResultInfo getQueryResultInfo() {
        return this.sqlStoredQuery.getQueryResultInfo();
    }

    @Override
    public InvocationContext<?, ?> getInvocationContext() {
        return this.invocationContext;
    }

    @NonNull
    private <K> Sort sortById(RuntimePersistentEntity<K> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    private boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    protected int sizeOf(Object value) {
        if (value == null) {
            return 1;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.size();
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int i = 0;
            for (Object o : iterable) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    private record CursoredQueryParameterBinder(String name, DataType dataType, Object value) implements QueryParameterBinding
    {
        public String getName() {
            return this.name;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

