/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria.metamodel;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.reflect.Member;

@Internal
abstract class RuntimePersistentPropertyAttribute<T, E>
implements Attribute<T, E> {
    protected final RuntimePersistentProperty<T> persistentProperty;

    public RuntimePersistentPropertyAttribute(RuntimePersistentProperty<T> persistentProperty) {
        this.persistentProperty = persistentProperty;
    }

    public String getName() {
        return this.persistentProperty.getName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        RuntimePersistentProperty<T> runtimePersistentProperty = this.persistentProperty;
        if (runtimePersistentProperty instanceof RuntimeAssociation) {
            RuntimeAssociation runtimeAssociation = (RuntimeAssociation)runtimePersistentProperty;
            return switch (runtimeAssociation.getKind()) {
                case Relation.Kind.EMBEDDED -> Attribute.PersistentAttributeType.EMBEDDED;
                case Relation.Kind.ONE_TO_ONE -> Attribute.PersistentAttributeType.ONE_TO_ONE;
                case Relation.Kind.MANY_TO_ONE -> Attribute.PersistentAttributeType.MANY_TO_ONE;
                case Relation.Kind.ONE_TO_MANY -> Attribute.PersistentAttributeType.ONE_TO_MANY;
                case Relation.Kind.MANY_TO_MANY -> Attribute.PersistentAttributeType.MANY_TO_MANY;
                default -> Attribute.PersistentAttributeType.BASIC;
            };
        }
        return Attribute.PersistentAttributeType.BASIC;
    }

    public ManagedType<T> getDeclaringType() {
        throw this.notSupportedOperation();
    }

    public Class<E> getJavaType() {
        return this.persistentProperty.getType();
    }

    public Member getJavaMember() {
        throw this.notSupportedOperation();
    }

    public boolean isAssociation() {
        return this.persistentProperty instanceof RuntimeAssociation;
    }

    public boolean isCollection() {
        return false;
    }

    protected IllegalStateException notSupportedOperation() {
        return new IllegalStateException("Not supported operation!");
    }
}

