/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityJoinSupport;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.RuntimeEmbeddedPersistentPropertyPathImpl;
import io.micronaut.data.runtime.criteria.RuntimePersistentAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentCollectionAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentListAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentPropertyPathImpl;
import io.micronaut.data.runtime.criteria.RuntimePersistentSetAssociationPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Internal
abstract class AbstractRuntimePersistentEntityJoinSupport<T, E>
extends AbstractPersistentEntityJoinSupport<T, E> {
    private final CriteriaBuilder criteriaBuilder;

    AbstractRuntimePersistentEntityJoinSupport(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    protected abstract List<Association> getCurrentPath();

    public abstract RuntimePersistentEntity<E> getPersistentEntity();

    protected <Y> PersistentAssociationPath<E, Y> createJoinAssociation(Association association, Join.Type associationJoinType, String alias) {
        Class type = ((RuntimeAssociation)association).getProperty().getType();
        RuntimeAssociation runtimeAssociation = (RuntimeAssociation)association;
        if (List.class.isAssignableFrom(type)) {
            return new RuntimePersistentListAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new RuntimePersistentSetAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new RuntimePersistentCollectionAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
        }
        return new RuntimePersistentAssociationPath(this, runtimeAssociation, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
    }

    public <Y> PersistentPropertyPath<Y> get(String attributeName) {
        RuntimePersistentProperty property = this.getPersistentEntity().getPropertyByNameIgnoreCase(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        return AbstractRuntimePersistentEntityJoinSupport.asPropertyPath(this, property, this.criteriaBuilder);
    }

    private static <Y> PersistentPropertyPath<Y> asPropertyPath(Path<?> parentPath, @NonNull RuntimePersistentProperty property, CriteriaBuilder criteriaBuilder) {
        RuntimeAssociation association;
        List<Association> associations;
        if (parentPath instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)parentPath;
            List pathAssociations = associationPath.getAssociations();
            associations = new ArrayList<Association>(pathAssociations.size() + 1);
            associations.addAll(pathAssociations);
            associations.add(associationPath.getAssociation());
        } else {
            associations = List.of();
        }
        if (property instanceof RuntimeAssociation && (association = (RuntimeAssociation)property).isEmbedded()) {
            return new RuntimeEmbeddedPersistentPropertyPathImpl(parentPath, associations, association, (path, persistentProperty) -> AbstractRuntimePersistentEntityJoinSupport.asPropertyPath(path, property, criteriaBuilder));
        }
        return new RuntimePersistentPropertyPathImpl(parentPath, associations, property, criteriaBuilder);
    }
}

