/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

@Internal
abstract class AbstractCascadeOperations {
    private final ConversionService conversionService;

    protected AbstractCascadeOperations(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    protected <T> void cascade(AnnotationMetadata annotationMetadata, Class<?> repositoryType, boolean fkOnly, Relation.Cascade cascadeType, CascadeContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, List<CascadeOp> cascadeOps) {
        block4: for (RuntimeAssociation association : persistentEntity.getAssociations()) {
            BeanProperty beanProperty = association.getProperty();
            Object child = beanProperty.get(entity);
            if (child == null) continue;
            if (association.isEmbedded()) {
                this.cascade(annotationMetadata, repositoryType, fkOnly, cascadeType, ctx.embedded((Association)association), association.getAssociatedEntity(), child, cascadeOps);
                continue;
            }
            if (!association.doesCascade(new Relation.Cascade[]{cascadeType}) || !fkOnly && association.isForeignKey() || association.getInverseSide().map(assoc -> ctx.rootAssociations.contains(assoc) || ctx.associations.contains(assoc)).orElse(false).booleanValue()) continue;
            RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
            switch (association.getKind()) {
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    cascadeOps.add(new CascadeOneOp(annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, child));
                    continue block4;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    PersistentAssociationPath inverse = association.getInversePathSide().orElse(null);
                    ArrayList children = (ArrayList)association.getProperty().get(entity);
                    if (children == null || !children.iterator().hasNext()) continue block4;
                    if (inverse != null && inverse.getAssociation().getKind() == Relation.Kind.MANY_TO_ONE) {
                        ArrayList entities = new ArrayList(CollectionUtils.iterableToList((Iterable)children));
                        ListIterator<Object> iterator = entities.listIterator();
                        while (iterator.hasNext()) {
                            Object newC;
                            Object c = iterator.next();
                            if (c == (newC = inverse.setPropertyValue(c, entity))) continue;
                            iterator.set(newC);
                        }
                        children = entities;
                    }
                    cascadeOps.add(new CascadeManyOp(annotationMetadata, repositoryType, ctx.relation((Association)association), cascadeType, (RuntimePersistentEntity<Object>)associatedEntity, children));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Cannot cascade for relation: " + association.getKind());
        }
    }

    protected <T> T afterCascadedOne(T entity, List<Association> associations, Object prevChild, Object newChild) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            PersistentAssociationPath inverse;
            if (association.isForeignKey() && (inverse = (PersistentAssociationPath)association.getInversePathSide().orElse(null)) != null) {
                newChild = inverse.setPropertyValue(newChild, entity);
            }
            if (prevChild != newChild) {
                entity = this.setProperty(association.getProperty(), entity, newChild);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedOne(innerEntity, associations.subList(1, associations.size()), prevChild, newChild);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    protected <T> T afterCascadedMany(T entity, List<Association> associations, Iterable<Object> prevChildren, List<Object> newChildren) {
        RuntimeAssociation association = (RuntimeAssociation)associations.iterator().next();
        if (associations.size() == 1) {
            ListIterator<Object> iterator = newChildren.listIterator();
            while (iterator.hasNext()) {
                Object newc;
                PersistentAssociationPath inverse;
                Object c = iterator.next();
                if (!association.isForeignKey() || (inverse = (PersistentAssociationPath)association.getInversePathSide().orElse(null)) == null || c == (newc = inverse.setPropertyValue(c, entity))) continue;
                iterator.set(newc);
            }
            if (prevChildren != newChildren) {
                entity = this.convertAndSetWithValue(association.getProperty(), entity, newChildren);
            }
            return entity;
        }
        BeanProperty property = association.getProperty();
        Object innerEntity = property.get(entity);
        Object newInnerEntity = this.afterCascadedMany(innerEntity, associations.subList(1, associations.size()), prevChildren, newChildren);
        if (newInnerEntity != innerEntity) {
            innerEntity = this.convertAndSetWithValue(property, entity, newInnerEntity);
        }
        return (T)innerEntity;
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    private <B, T> B convertAndSetWithValue(BeanProperty<B, T> beanProperty, B bean, T value) {
        Argument argument = beanProperty.asArgument();
        ArgumentConversionContext context = ConversionContext.of((Argument)argument);
        Object convertedValue = this.conversionService.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + beanProperty.getType()))));
        if (beanProperty.isReadOnly()) {
            return (B)beanProperty.withValue(bean, convertedValue);
        }
        beanProperty.set(bean, convertedValue);
        return bean;
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        if (associations == null) {
            return Collections.singletonList(association);
        }
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }

    protected static final class CascadeContext {
        public final List<Association> rootAssociations;
        public final Object parent;
        public final RuntimePersistentEntity<Object> parentPersistentEntity;
        public final List<Association> associations;

        CascadeContext(List<Association> rootAssociations, Object parent, RuntimePersistentEntity<Object> parentPersistentEntity, List<Association> associations) {
            this.rootAssociations = rootAssociations;
            this.parent = parent;
            this.parentPersistentEntity = parentPersistentEntity;
            this.associations = associations;
        }

        public static CascadeContext of(List<Association> rootAssociations, Object parent, RuntimePersistentEntity<Object> parentPersistentEntity) {
            return new CascadeContext(rootAssociations, parent, parentPersistentEntity, Collections.emptyList());
        }

        CascadeContext embedded(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, this.parentPersistentEntity, AbstractCascadeOperations.associated(this.associations, association));
        }

        CascadeContext relation(Association association) {
            return new CascadeContext(this.rootAssociations, this.parent, this.parentPersistentEntity, AbstractCascadeOperations.associated(this.associations, association));
        }

        public Association getAssociation() {
            return (Association)CollectionUtils.last(this.associations);
        }
    }

    protected static final class CascadeOneOp
    extends CascadeOp {
        public final Object child;

        CascadeOneOp(AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Object child) {
            super(annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.child = child;
        }
    }

    protected static final class CascadeManyOp
    extends CascadeOp {
        public final Iterable<Object> children;

        CascadeManyOp(AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity, Iterable<Object> children) {
            super(annotationMetadata, repositoryType, ctx, cascadeType, childPersistentEntity);
            this.children = children;
        }
    }

    protected static abstract class CascadeOp {
        public final AnnotationMetadata annotationMetadata;
        public final Class<?> repositoryType;
        public final CascadeContext ctx;
        public final Relation.Cascade cascadeType;
        public final RuntimePersistentEntity<Object> childPersistentEntity;

        CascadeOp(AnnotationMetadata annotationMetadata, Class<?> repositoryType, CascadeContext ctx, Relation.Cascade cascadeType, RuntimePersistentEntity<Object> childPersistentEntity) {
            this.annotationMetadata = annotationMetadata;
            this.repositoryType = repositoryType;
            this.ctx = ctx;
            this.cascadeType = cascadeType;
            this.childPersistentEntity = childPersistentEntity;
        }
    }
}

