/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCriteriaRepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractPreparedQueryCriteriaRepositoryOperations;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.List;
import java.util.concurrent.CompletionStage;

@Internal
final class PreparedQueryAsyncCriteriaRepositoryOperations
extends AbstractPreparedQueryCriteriaRepositoryOperations
implements AsyncCriteriaRepositoryOperations {
    private final CriteriaBuilder criteriaBuilder;
    private final AsyncRepositoryOperations operations;

    public PreparedQueryAsyncCriteriaRepositoryOperations(CriteriaBuilder criteriaBuilder, AsyncRepositoryOperations asyncRepositoryOperations, RepositoryOperations operations, MethodInvocationContext<?, ?> context, QueryBuilder queryBuilder, Class<?> entityRoot, Pageable pageable) {
        super(operations, context, queryBuilder, entityRoot, pageable);
        this.criteriaBuilder = criteriaBuilder;
        this.operations = asyncRepositoryOperations;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public CompletionStage<Boolean> exists(CriteriaQuery<?> query) {
        return this.operations.exists(this.createExists(query));
    }

    public <R> CompletionStage<R> findOne(CriteriaQuery<R> query) {
        return this.operations.findOne(this.createFindOne(query));
    }

    public <T> CompletionStage<List<T>> findAll(CriteriaQuery<T> query) {
        return this.operations.findAll(this.createFindAll(query)).thenApply(CollectionUtils::iterableToList);
    }

    public <T> CompletionStage<List<T>> findAll(CriteriaQuery<T> query, int offset, int limit) {
        throw new IllegalStateException("Not supported!");
    }

    public CompletionStage<Number> updateAll(CriteriaUpdate<Number> query) {
        return this.operations.executeUpdate(this.createUpdateAll(query));
    }

    public CompletionStage<Number> deleteAll(CriteriaDelete<Number> query) {
        return this.operations.executeDelete(this.createDeleteAll(query));
    }
}

