/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.query.DefaultPreparedQueryResolver;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryResolver;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public abstract class AbstractPreparedQueryCriteriaRepositoryOperations {
    private final MethodContextAwareStoredQueryDecorator storedQueryDecorator;
    private final PreparedQueryDecorator preparedQueryDecorator;
    private final PreparedQueryResolver preparedQueryResolver;
    private final MethodInvocationContext<?, ?> context;
    private final QueryBuilder queryBuilder;
    private final Class<?> entityRoot;
    private final Pageable pageable;

    protected AbstractPreparedQueryCriteriaRepositoryOperations(final RepositoryOperations operations, MethodInvocationContext<?, ?> context, QueryBuilder queryBuilder, Class<?> entityRoot, Pageable pageable) {
        PreparedQueryResolver preparedQueryResolver;
        Object decorator;
        this.context = context;
        this.queryBuilder = queryBuilder;
        this.entityRoot = entityRoot;
        Pageable pageable2 = this.pageable = pageable == null ? Pageable.unpaged() : pageable;
        if (operations instanceof MethodContextAwareStoredQueryDecorator) {
            this.storedQueryDecorator = (MethodContextAwareStoredQueryDecorator)operations;
        } else if (operations instanceof StoredQueryDecorator) {
            decorator = (StoredQueryDecorator)operations;
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){
                final /* synthetic */ StoredQueryDecorator val$decorator;
                {
                    this.val$decorator = storedQueryDecorator;
                }

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return this.val$decorator.decorate(storedQuery);
                }
            };
        } else {
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return storedQuery;
                }
            };
        }
        Object object = this.preparedQueryDecorator = operations instanceof PreparedQueryDecorator ? (decorator = (PreparedQueryDecorator)operations) : new PreparedQueryDecorator(){

            public <E, K> PreparedQuery<E, K> decorate(PreparedQuery<E, K> preparedQuery) {
                return preparedQuery;
            }
        };
        if (operations instanceof PreparedQueryResolver) {
            PreparedQueryResolver resolver = (PreparedQueryResolver)operations;
            preparedQueryResolver = resolver;
        } else {
            preparedQueryResolver = new DefaultPreparedQueryResolver(){

                @Override
                protected ConversionService getConversionService() {
                    return operations.getConversionService();
                }
            };
        }
        this.preparedQueryResolver = preparedQueryResolver;
    }

    protected final PreparedQuery<Object, Boolean> createExists(CriteriaQuery<?> query) {
        return this.toPreparedQuery(this.buildExists(query));
    }

    protected final <K> PreparedQuery<Object, K> createFindOne(CriteriaQuery<K> query) {
        return this.toPreparedQuery(this.buildFind(query, true));
    }

    protected final <K> PreparedQuery<Object, K> createFindAll(CriteriaQuery<K> query) {
        return this.toPreparedQuery(this.buildFind(query, false));
    }

    protected final PreparedQuery<?, Number> createUpdateAll(CriteriaUpdate<Number> query) {
        return this.toPreparedQuery(this.buildUpdateAll(query));
    }

    protected final PreparedQuery<?, Number> createDeleteAll(CriteriaDelete<Number> query) {
        return this.toPreparedQuery(this.buildDeleteAll(query));
    }

    private <E, QR> PreparedQuery<E, QR> toPreparedQuery(StoredQuery<E, ?> storedQuery) {
        storedQuery = this.storedQueryDecorator.decorate(this.context, storedQuery);
        PreparedQuery<E, ?> preparedQuery = this.preparedQueryResolver.resolveQuery(this.context, storedQuery, this.pageable);
        PreparedQuery<E, ?> decorated = this.preparedQueryDecorator.decorate(preparedQuery);
        this.context.setAttribute((CharSequence)"PREPARED_QUERY", decorated);
        return decorated;
    }

    private <E, T> StoredQuery<E, T> buildFind(CriteriaQuery<T> criteriaQuery, boolean isSingle) {
        boolean isCompoundSelection;
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(this.context, this.queryBuilder);
        Collection joinPaths = queryResult.getJoinPaths();
        Selection selection = ((AbstractPersistentEntityCriteriaQuery)criteriaQuery).getSelection();
        boolean bl = isCompoundSelection = selection != null && selection.isCompoundSelection();
        if (isSingle) {
            return QueryResultStoredQuery.single(StoredQuery.OperationType.QUERY, this.context.getName(), this.context.getAnnotationMetadata(), queryResult, this.entityRoot, criteriaQuery.getResultType(), isCompoundSelection, joinPaths);
        }
        return QueryResultStoredQuery.many(this.context.getName(), this.context.getAnnotationMetadata(), queryResult, this.entityRoot, criteriaQuery.getResultType(), !this.pageable.isUnpaged(), isCompoundSelection, joinPaths);
    }

    private <E> StoredQuery<E, ?> buildExists(CriteriaQuery<?> criteriaQuery) {
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(this.context, this.queryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.EXISTS, this.context.getName(), this.context.getAnnotationMetadata(), queryResult, this.entityRoot);
    }

    private <E> StoredQuery<E, ?> buildUpdateAll(CriteriaUpdate<E> criteriaUpdate) {
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaUpdate).buildQuery(this.context, this.queryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.UPDATE, this.context.getName(), this.context.getAnnotationMetadata(), queryResult, criteriaUpdate.getRoot().getJavaType());
    }

    private <E> StoredQuery<E, ?> buildDeleteAll(CriteriaDelete<E> criteriaDelete) {
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaDelete).buildQuery(this.context, this.queryBuilder);
        return QueryResultStoredQuery.single(StoredQuery.OperationType.DELETE, this.context.getName(), this.context.getAnnotationMetadata(), queryResult, criteriaDelete.getRoot().getJavaType());
    }

    private Set<JoinPath> mergeJoinPaths(Collection<JoinPath> joinPaths, Collection<JoinPath> additionalJoinPaths) {
        HashSet resultPaths = CollectionUtils.newHashSet((int)(joinPaths.size() + additionalJoinPaths.size()));
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            resultPaths.addAll(joinPaths);
        }
        if (CollectionUtils.isNotEmpty(additionalJoinPaths)) {
            Map existingPathsByPath = resultPaths.stream().collect(Collectors.toMap(JoinPath::getPath, Function.identity()));
            resultPaths.addAll(additionalJoinPaths.stream().filter(jp -> !existingPathsByPath.containsKey(jp.getPath())).collect(Collectors.toSet()));
        }
        return resultPaths;
    }
}

