/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultUpdateInterceptor<T>
extends AbstractQueryInterceptor<T, Object>
implements UpdateInterceptor<T> {
    public DefaultUpdateInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Object> context) {
        PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
        Number number = this.operations.executeUpdate(preparedQuery).orElse(null);
        Argument returnType = context.getReturnType().asArgument();
        Class type = ReflectionUtils.getWrapperType((Class)returnType.getType());
        if (Number.class.isAssignableFrom(type)) {
            if (type.isInstance(number)) {
                return number;
            }
            return this.operations.getConversionService().convert((Object)number, returnType).orElse(0);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return number == null || number.longValue() < 0L;
        }
        return null;
    }
}

