/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.TenantId;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import io.micronaut.data.runtime.multitenancy.TenantResolver;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;

@Requires(beans={TenantResolver.class})
@Singleton
public class TenantIdEntityEventListener
extends AutoPopulatedEntityEventListener
implements PropertyAutoPopulator<TenantId> {
    private final TenantResolver tenantResolver;
    private final DataConversionService conversionService;

    public TenantIdEntityEventListener(TenantResolver tenantResolver, DataConversionService conversionService) {
        this.tenantResolver = tenantResolver;
        this.conversionService = conversionService;
    }

    @Override
    @NonNull
    protected List<Class<? extends Annotation>> getEventTypes() {
        return List.of(PrePersist.class);
    }

    @Override
    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return prop -> {
            AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
            return annotationMetadata.hasStereotype(TenantId.class);
        };
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        for (RuntimePersistentProperty<Object> property : this.getApplicableProperties((RuntimePersistentEntity<Object>)context.getPersistentEntity())) {
            Object newValue;
            if (!property.getAnnotationMetadata().hasStereotype(TenantId.class)) continue;
            if (property.getProperty().get(context.getEntity()) != null) {
                return true;
            }
            Argument argument = property.getArgument();
            if (!argument.isInstance(newValue = this.tenantResolver.resolveTenantIdentifier())) {
                newValue = this.conversionService.convert(newValue, argument.getType());
            }
            context.setProperty(property.getProperty(), newValue);
            break;
        }
        return true;
    }

    @NonNull
    public Object populate(RuntimePersistentProperty<?> property, @Nullable Object previousValue) {
        return this.conversionService.convertRequired(this.tenantResolver.resolveTenantIdentifier(), property.getArgument());
    }
}

