/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import java.util.UUID;

public interface ResultReader<RS, IDX> {
    default public <T> T convertRequired(@NonNull Object value, Class<T> type) {
        return this.getConversionService().convert(value, type).orElseThrow(() -> new DataAccessException("Cannot convert type [" + value.getClass() + "] with value [" + value + "] to target type: " + type + ". Consider defining a TypeConverter bean to handle this case."));
    }

    default public <T> T convertRequired(@NonNull Object value, Argument<T> type) {
        return this.getConversionService().convert(value, type).orElseThrow(() -> new DataAccessException("Cannot convert type [" + value.getClass() + "] with value [" + value + "] to target type: " + type + ". Consider defining a TypeConverter bean to handle this case."));
    }

    @Nullable
    public <T> T getRequiredValue(RS var1, IDX var2, Class<T> var3) throws DataAccessException;

    public boolean next(RS var1);

    @Nullable
    default public Object readDynamic(@NonNull RS resultSet, @NonNull IDX index, @NonNull DataType dataType) {
        return switch (dataType) {
            case DataType.STRING, DataType.JSON -> this.readString(resultSet, index);
            case DataType.UUID -> this.readUUID(resultSet, index);
            case DataType.LONG -> this.readLong(resultSet, index);
            case DataType.INTEGER -> this.readInt(resultSet, index);
            case DataType.BOOLEAN -> this.readBoolean(resultSet, index);
            case DataType.BYTE -> this.readByte(resultSet, index);
            case DataType.TIMESTAMP -> this.readTimestamp(resultSet, index);
            case DataType.TIME -> this.readTime(resultSet, index);
            case DataType.DATE -> this.readDate(resultSet, index);
            case DataType.CHARACTER -> Character.valueOf(this.readChar(resultSet, index));
            case DataType.FLOAT -> Float.valueOf(this.readFloat(resultSet, index));
            case DataType.SHORT -> this.readShort(resultSet, index);
            case DataType.DOUBLE -> this.readDouble(resultSet, index);
            case DataType.BYTE_ARRAY -> this.readBytes(resultSet, index);
            case DataType.BIGDECIMAL -> this.readBigDecimal(resultSet, index);
            default -> this.getRequiredValue(resultSet, index, Object.class);
        };
    }

    default public long readLong(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Long.TYPE);
    }

    default public char readChar(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Character.TYPE).charValue();
    }

    default public Date readDate(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Date.class);
    }

    default public Date readTimestamp(RS resultSet, IDX index) {
        return this.getRequiredValue(resultSet, index, Date.class);
    }

    default public Time readTime(RS resultSet, IDX index) {
        return this.getRequiredValue(resultSet, index, Time.class);
    }

    @Nullable
    default public String readString(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, String.class);
    }

    @Nullable
    default public UUID readUUID(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, UUID.class);
    }

    default public int readInt(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Integer.TYPE);
    }

    default public boolean readBoolean(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Boolean.TYPE);
    }

    default public float readFloat(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Float.TYPE).floatValue();
    }

    default public byte readByte(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Byte.TYPE);
    }

    default public short readShort(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Short.TYPE);
    }

    default public double readDouble(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, Double.TYPE);
    }

    default public BigDecimal readBigDecimal(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, BigDecimal.class);
    }

    default public byte[] readBytes(RS resultSet, IDX name) {
        return this.getRequiredValue(resultSet, name, byte[].class);
    }

    default public ConversionService getConversionService() {
        return ConversionService.SHARED;
    }
}

