/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyInPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyInValuesPredicate;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.query.QueryModel;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class LiteralsAsParametersQueryModelPredicateVisitor
extends QueryModelPredicateVisitor {
    private final AbstractCriteriaBuilder criteriaBuilder;

    public LiteralsAsParametersQueryModelPredicateVisitor(AbstractCriteriaBuilder criteriaBuilder, QueryModel qm) {
        super(qm);
        this.criteriaBuilder = criteriaBuilder;
    }

    public void visit(PersistentPropertyBinaryPredicate<?> predicate) {
        Expression expression = predicate.getExpression();
        if (expression instanceof LiteralExpression) {
            super.visit(new PersistentPropertyBinaryPredicate(predicate.getPropertyPath(), this.asParameter(expression), predicate.getOp()));
        } else {
            super.visit(predicate);
        }
    }

    public void visit(PersistentPropertyBetweenPredicate<?> propertyBetweenPredicate) {
        if (!(propertyBetweenPredicate.getFrom() instanceof ParameterExpression) || !(propertyBetweenPredicate.getTo() instanceof ParameterExpression)) {
            super.visit(new PersistentPropertyBetweenPredicate(propertyBetweenPredicate.getPropertyPath(), this.asParameter(propertyBetweenPredicate.getFrom()), this.asParameter(propertyBetweenPredicate.getTo())));
        } else {
            super.visit(propertyBetweenPredicate);
        }
    }

    public void visit(PersistentPropertyInPredicate<?> inValues) {
        if (inValues.getValues().stream().allMatch(v -> v instanceof ParameterExpression)) {
            super.visit(inValues);
        } else {
            super.visit(new PersistentPropertyInPredicate(inValues.getPropertyPath(), this.asCollectionParameter(inValues.getValues())));
        }
    }

    public void visit(PersistentPropertyInValuesPredicate<?> inValues) {
        if (inValues.getValues().stream().allMatch(v -> v instanceof ParameterExpression)) {
            super.visit(inValues);
        } else {
            super.visit(new PersistentPropertyInValuesPredicate(inValues.getPropertyPath(), this.asCollectionParameter(inValues.getValues())));
        }
    }

    @NotNull
    private ParameterExpression<?> asParameter(Object exp) {
        Object value;
        Class<?> type;
        if (exp instanceof ParameterExpression) {
            return (ParameterExpression)exp;
        }
        Objects.requireNonNull(exp);
        if (exp instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)exp;
            type = literalExpression.getJavaType();
            value = literalExpression.getValue();
        } else {
            if (exp instanceof Expression) {
                throw new IllegalStateException("Unexpected expression!");
            }
            type = exp.getClass();
            value = exp;
        }
        return this.criteriaBuilder.parameter(type, null, value);
    }

    @NotNull
    private Set<Expression<?>> asCollectionParameter(Collection<?> values) {
        List literals = values.stream().map(v -> {
            if (v instanceof LiteralExpression) {
                return (LiteralExpression)v;
            }
            if (v instanceof Expression) {
                throw new IllegalStateException("Expected to have all literal values");
            }
            return new LiteralExpression(v);
        }).collect(Collectors.toList());
        List literalValues = literals.stream().map(LiteralExpression::getValue).collect(Collectors.toList());
        Class javaType = ((LiteralExpression)literals.iterator().next()).getJavaType();
        return Collections.singleton(this.criteriaBuilder.parameter(javaType, null, literalValues));
    }
}

