/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import java.util.List;

@Internal
public class FindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    protected FindPageSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            PreparedQuery preparedQuery = this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE);
            Iterable iterable = this.operations.findAll(preparedQuery);
            List resultList = CollectionUtils.iterableToList((Iterable)iterable);
            return Page.of((List)resultList, (Pageable)pageable, (long)resultList.size());
        }
        PreparedQuery preparedQuery = this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE);
        PreparedQuery countQuery = this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.COUNT);
        Iterable iterable = this.operations.findAll(preparedQuery);
        List resultList = CollectionUtils.iterableToList((Iterable)iterable);
        Number count = (Number)this.operations.findOne(countQuery);
        Page page = Page.of((List)resultList, (Pageable)this.getPageable(context), (long)(count != null ? count.longValue() : 0L));
        Class rt = context.getReturnType().getType();
        if (rt.isInstance(page)) {
            return page;
        }
        return this.operations.getConversionService().convert((Object)page, rt).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + rt));
    }
}

