/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.query;

import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.runtime.DelegatingQueryParameterBinding;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

@Internal
public class DefaultBindableParametersStoredQuery<E, R>
implements BindableParametersStoredQuery<E, R>,
DelegateStoredQuery<E, R> {
    private final StoredQuery<E, R> storedQuery;
    private final RuntimePersistentEntity<E> runtimePersistentEntity;

    public DefaultBindableParametersStoredQuery(StoredQuery<E, R> storedQuery, RuntimePersistentEntity<E> runtimePersistentEntity) {
        this.storedQuery = storedQuery;
        this.runtimePersistentEntity = runtimePersistentEntity;
        Objects.requireNonNull(storedQuery, "Query cannot be null");
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.runtimePersistentEntity;
    }

    @Override
    public StoredQuery<E, R> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    @Override
    public void bindParameters(BindableParametersStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues) {
        for (QueryParameterBinding queryParameterBinding : this.storedQuery.getQueryBindings()) {
            this.bindParameter(binder, invocationContext, entity, previousValues, queryParameterBinding);
        }
    }

    protected final void bindParameter(BindableParametersStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues, QueryParameterBinding binding) {
        List<Object> values;
        RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
        Class parameterConverter = binding.getParameterConverterClass();
        Object value = binding.getValue();
        RuntimePersistentProperty persistentProperty = null;
        Argument argument = null;
        if (value == null) {
            PersistentPropertyPath pp;
            if (binding.getParameterIndex() != -1) {
                this.requireInvocationContext(invocationContext);
                value = this.resolveParameterValue((QueryParameterBinding)binding, invocationContext.getParameterValues());
                argument = invocationContext.getArguments()[binding.getParameterIndex()];
            } else if (binding.isAutoPopulated()) {
                pp = this.getRequiredPropertyPath((QueryParameterBinding)binding, (RuntimePersistentEntity)persistentEntity);
                persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                if (binding.isRequiresPreviousPopulatedValue()) {
                    if (previousValues != null) {
                        value = previousValues.get(binding);
                    }
                } else if (entity == null) {
                    Object previousValue = null;
                    QueryParameterBinding previousPopulatedValueParameter = binding.getPreviousPopulatedValueParameter();
                    if (previousPopulatedValueParameter != null) {
                        if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                            throw new IllegalStateException("Previous value parameter cannot be bind!");
                        }
                        this.requireInvocationContext(invocationContext);
                        previousValue = this.resolveParameterValue(previousPopulatedValueParameter, invocationContext.getParameterValues());
                    }
                    value = binder.autoPopulateRuntimeProperty(persistentProperty, previousValue);
                } else {
                    value = pp.getPropertyValue(entity);
                }
                value = binder.convert(value, persistentProperty);
                parameterConverter = null;
            } else if (entity != null) {
                pp = this.getRequiredPropertyPath((QueryParameterBinding)binding, (RuntimePersistentEntity)persistentEntity);
                value = pp.getPropertyValue(entity);
                persistentProperty = (RuntimePersistentProperty)pp.getProperty();
            } else {
                int currentIndex = binder.currentIndex();
                if (currentIndex != -1) {
                    throw new IllegalStateException("Invalid query [" + this.getQuery() + "]. Unable to establish parameter value for parameter at position: " + currentIndex);
                }
                throw new IllegalStateException("Invalid query [" + this.getQuery() + "]. Unable to establish parameter value for parameter: " + binding.getName());
            }
        }
        if (persistentProperty != null) {
            argument = persistentProperty.getArgument();
            if (binding.getDataType() != persistentProperty.getDataType()) {
                final RuntimePersistentProperty finalPersistentProperty = persistentProperty;
                binding = new DelegatingQueryParameterBinding((QueryParameterBinding)binding){

                    public DataType getDataType() {
                        return finalPersistentProperty.getDataType();
                    }
                };
            }
        }
        List<Object> list = values = binding.isExpandable() ? this.expandValue(value, binding.getDataType()) : null;
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        } else if (values != null && values.size() == 1) {
            value = values.iterator().next();
            values = null;
        }
        if (values == null) {
            if (parameterConverter != null) {
                value = binder.convert(parameterConverter, value, argument);
            } else if (persistentProperty != null) {
                value = binder.convert(value, persistentProperty);
            }
            binder.bindOne((QueryParameterBinding)binding, value);
        } else {
            values = new ArrayList<Object>(values);
            ListIterator<Object> iterator = values.listIterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (parameterConverter != null) {
                    v = binder.convert(parameterConverter, v, argument);
                } else if (persistentProperty != null) {
                    v = binder.convert(v, persistentProperty);
                }
                iterator.set(v);
            }
            binder.bindMany((QueryParameterBinding)binding, (Collection<Object>)values);
        }
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] parameterArray) {
        Object value = parameterArray[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(prop, Argument.OBJECT_ARGUMENT);
            }
        }
        return value;
    }

    private List<Object> expandValue(Object value, @Nullable DataType dataType) {
        if (value == null || dataType != null && dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    protected final <T> PersistentPropertyPath getRequiredPropertyPath(QueryParameterBinding queryParameterBinding, RuntimePersistentEntity<T> persistentEntity) {
        CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
        PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
        if (pp == null) {
            throw new IllegalStateException("Cannot find property: " + String.join((CharSequence)".", propertyPath));
        }
        return pp;
    }

    protected final void requireInvocationContext(InvocationContext<?, ?> invocationContext) {
        if (invocationContext == null) {
            throw new IllegalStateException("Invocation context is required!");
        }
    }
}

