/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.AbstractRuntimePersistentEntityJoinSupport;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityPath;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.List;

@Internal
class RuntimePersistentAssociationPath<Owner, E>
extends AbstractRuntimePersistentEntityJoinSupport<Owner, E>
implements RuntimePersistentEntityPath<E>,
PersistentAssociationPath<Owner, E> {
    private final Path<?> parentPath;
    private final RuntimeAssociation<Owner> association;
    private final List<Association> associations;
    private Join.Type associationJoinType;
    @Nullable
    private String alias;

    RuntimePersistentAssociationPath(Path<?> parentPath, RuntimeAssociation<Owner> association, List<Association> associations, Join.Type associationJoinType, @Nullable String alias) {
        this.parentPath = parentPath;
        this.association = association;
        this.associations = associations;
        this.associationJoinType = associationJoinType;
        this.alias = alias;
    }

    public Join.Type getAssociationJoinType() {
        return this.associationJoinType;
    }

    public void setAssociationJoinType(Join.Type type) {
        this.associationJoinType = type;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void accept(SelectionVisitor selectionVisitor) {
        selectionVisitor.visit((PersistentPropertyPath)this);
    }

    public Path<?> getParentPath() {
        return this.parentPath;
    }

    public RuntimeAssociation<Owner> getProperty() {
        return this.association;
    }

    public Association getAssociation() {
        return this.association;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.association.getAssociatedEntity();
    }

    @Override
    protected List<Association> getCurrentPath() {
        return RuntimePersistentAssociationPath.associated(this.getAssociations(), this.association);
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }

    public String toString() {
        return "RuntimePersistentAssociationPath{parentPath=" + this.parentPath + ", association=" + this.association + ", associations=" + this.associations + '}';
    }
}

