/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.query.DefaultStoredQueryResolver;
import io.micronaut.data.runtime.query.StoredQueryResolver;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    private final Map<RepositoryMethodKey, QueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, QueryBuilder>();
    private final RuntimeCriteriaBuilder criteriaBuilder;
    private final StoredQueryResolver storedQueryResolver;

    protected AbstractSpecificationInterceptor(final RepositoryOperations operations) {
        super(operations);
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)operations.getApplicationContext().getBean(RuntimeEntityRegistry.class);
        this.criteriaBuilder = new RuntimeCriteriaBuilder(runtimeEntityRegistry);
        this.storedQueryResolver = operations instanceof StoredQueryResolver ? (StoredQueryResolver)operations : new DefaultStoredQueryResolver(){

            @Override
            protected HintsCapableRepository getHintsCapableRepository() {
                return operations;
            }
        };
    }

    protected final <E, QR> PreparedQuery<E, QR> preparedQueryForCriteria(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type) {
        Object storedQuery;
        String[] queryParts;
        QueryResult queryResult;
        Predicate predicate;
        PersistentEntityRoot root;
        QuerySpecification<Object> specification;
        Class<Object> rootEntity = this.getRequiredRootEntity(context);
        Pageable pageable = Pageable.UNPAGED;
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Pageable)) continue;
            pageable = (Pageable)param;
            break;
        }
        QueryBuilder sqlQueryBuilder = this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> {
            Class builder = (Class)context.getAnnotationMetadata().classValue(RepositoryConfiguration.class, "queryBuilder").orElseThrow(() -> new IllegalStateException("Cannot determine QueryBuilder"));
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)builder);
            if (introspection.getConstructorArguments().length == 1 && introspection.getConstructorArguments()[0].getType() == AnnotationMetadata.class) {
                return (QueryBuilder)introspection.instantiate(new Object[]{context.getAnnotationMetadata()});
            }
            return (QueryBuilder)introspection.instantiate();
        });
        if (type == Type.COUNT || type == Type.FIND_ALL || type == Type.FIND_ONE || type == Type.FIND_PAGE) {
            specification = this.getQuerySpecification(context);
            PersistentEntityCriteriaQuery<Object> criteriaQuery = this.criteriaBuilder.createQuery();
            root = criteriaQuery.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaQuery, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            if (type == Type.FIND_ALL) {
                for (Predicate param : context.getParameterValues()) {
                    Sort sort;
                    if (!(param instanceof Sort) || param == pageable || !(sort = (Sort)param).isSorted()) continue;
                    criteriaQuery.orderBy(this.getOrders(sort, (Root<?>)root, (CriteriaBuilder)this.criteriaBuilder));
                    break;
                }
            } else if (type == Type.COUNT) {
                criteriaQuery.select((Selection)this.criteriaBuilder.count((Expression)root));
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery(sqlQueryBuilder);
        } else if (type == Type.DELETE_ALL) {
            specification = this.getDeleteSpecification(context);
            PersistentEntityCriteriaDelete criteriaDelete = this.criteriaBuilder.createCriteriaDelete(rootEntity);
            root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaDelete, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaDelete).buildQuery(sqlQueryBuilder);
        } else if (type == Type.UPDATE_ALL) {
            specification = this.getUpdateSpecification(context);
            PersistentEntityCriteriaUpdate criteriaUpdate = this.criteriaBuilder.createCriteriaUpdate(rootEntity);
            root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaUpdate, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaUpdate).buildQuery(sqlQueryBuilder);
        } else {
            throw new IllegalStateException("Unknown criteria type: " + (Object)((Object)type));
        }
        String query = queryResult.getQuery();
        String update = queryResult.getUpdate();
        List parameterBindings = queryResult.getParameterBindings();
        ArrayList<QueryParameterBinding> queryParameters = new ArrayList<QueryParameterBinding>(parameterBindings.size());
        for (io.micronaut.data.model.query.builder.QueryParameterBinding p : parameterBindings) {
            queryParameters.add(new QueryResultParameterBinding(p, queryParameters));
        }
        String[] stringArray = queryParts = queryParameters.stream().anyMatch(QueryParameterBinding::isExpandable) ? queryResult.getQueryParts().toArray(new String[0]) : null;
        if (type == Type.COUNT) {
            storedQuery = this.storedQueryResolver.createCountStoredQuery(context.getExecutableMethod(), DataMethod.OperationType.COUNT, context.getName(), context.getAnnotationMetadata(), rootEntity, query, queryParts, queryParameters);
        } else if (type == Type.FIND_ALL) {
            storedQuery = this.storedQueryResolver.createStoredQuery(context.getExecutableMethod(), DataMethod.OperationType.QUERY, context.getName(), context.getAnnotationMetadata(), rootEntity, query, null, queryParts, queryParameters, !pageable.isUnpaged(), false);
        } else {
            DataMethod.OperationType operationType;
            switch (type) {
                case COUNT: {
                    operationType = DataMethod.OperationType.COUNT;
                    break;
                }
                case DELETE_ALL: {
                    operationType = DataMethod.OperationType.DELETE;
                    break;
                }
                case UPDATE_ALL: {
                    operationType = DataMethod.OperationType.UPDATE;
                    break;
                }
                case FIND_ALL: 
                case FIND_ONE: 
                case FIND_PAGE: {
                    operationType = DataMethod.OperationType.QUERY;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown value: " + (Object)((Object)type));
                }
            }
            storedQuery = this.storedQueryResolver.createStoredQuery(context.getExecutableMethod(), operationType, context.getName(), context.getAnnotationMetadata(), rootEntity, query, update, queryParts, queryParameters, false, true);
        }
        return this.preparedQueryResolver.resolveQuery(context, storedQuery, pageable);
    }

    @Nullable
    protected QuerySpecification<Object> getQuerySpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof QuerySpecification) {
            return (QuerySpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return QuerySpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(QuerySpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + QuerySpecification.class + " or " + PredicateSpecification.class);
    }

    @Nullable
    protected DeleteSpecification<Object> getDeleteSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof DeleteSpecification) {
            return (DeleteSpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return DeleteSpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(DeleteSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + DeleteSpecification.class + " or " + PredicateSpecification.class);
    }

    @Nullable
    protected UpdateSpecification<Object> getUpdateSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof UpdateSpecification) {
            return (UpdateSpecification)parameterValue;
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(UpdateSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + UpdateSpecification.class);
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root.get(order.getProperty());
            orders.add(order.isAscending() ? cb.asc((Expression)propertyPath) : cb.desc((Expression)propertyPath));
        }
        return orders;
    }

    private static class QueryResultParameterBinding
    implements QueryParameterBinding {
        private final io.micronaut.data.model.query.builder.QueryParameterBinding p;
        private final List<QueryParameterBinding> all;
        private boolean previousInitialized;
        private QueryParameterBinding previousPopulatedValueParameter;

        public QueryResultParameterBinding(io.micronaut.data.model.query.builder.QueryParameterBinding p, List<QueryParameterBinding> all) {
            this.p = p;
            this.all = all;
        }

        public String getName() {
            return this.p.getKey();
        }

        public DataType getDataType() {
            return this.p.getDataType();
        }

        public Class<?> getParameterConverterClass() {
            return (Class)ClassUtils.forName((String)this.p.getConverterClassName(), null).orElseThrow(IllegalStateException::new);
        }

        public int getParameterIndex() {
            return this.p.getParameterIndex();
        }

        public String[] getParameterBindingPath() {
            return this.p.getParameterBindingPath();
        }

        public String[] getPropertyPath() {
            return this.p.getPropertyPath();
        }

        public boolean isAutoPopulated() {
            return this.p.isAutoPopulated();
        }

        public boolean isRequiresPreviousPopulatedValue() {
            return this.p.isRequiresPreviousPopulatedValue();
        }

        public QueryParameterBinding getPreviousPopulatedValueParameter() {
            if (!this.previousInitialized) {
                for (QueryParameterBinding it : this.all) {
                    if (it == this || it.getParameterIndex() == -1 || !Arrays.equals(this.getPropertyPath(), it.getPropertyPath())) continue;
                    this.previousPopulatedValueParameter = it;
                    break;
                }
                this.previousInitialized = true;
            }
            return this.previousPopulatedValueParameter;
        }

        public boolean isExpandable() {
            return this.p.isExpandable();
        }
    }

    protected static enum Type {
        COUNT,
        FIND_ONE,
        FIND_PAGE,
        FIND_ALL,
        DELETE_ALL,
        UPDATE_ALL;

    }
}

