/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DateCreated;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Singleton
public class AutoTimestampEntityEventListener
extends AutoPopulatedEntityEventListener
implements PropertyAutoPopulator<DateUpdated> {
    private final DateTimeProvider<?> dateTimeProvider;
    private final DataConversionService<?> conversionService;

    public AutoTimestampEntityEventListener(DateTimeProvider<?> dateTimeProvider, DataConversionService<?> conversionService) {
        this.dateTimeProvider = dateTimeProvider;
        this.conversionService = conversionService;
    }

    @Override
    @NonNull
    protected List<Class<? extends Annotation>> getEventTypes() {
        return Arrays.asList(PrePersist.class, PreUpdate.class);
    }

    @Override
    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return prop -> {
            AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
            return annotationMetadata.hasAnnotation(DateCreated.class) || annotationMetadata.hasAnnotation(DateUpdated.class);
        };
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        this.autoTimestampIfNecessary(context, false);
        return true;
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        this.autoTimestampIfNecessary(context, true);
        return true;
    }

    @NonNull
    public Object populate(RuntimePersistentProperty<?> property, @Nullable Object previousValue) {
        return this.conversionService.convertRequired(this.dateTimeProvider.getNow(), property.getArgument());
    }

    private void autoTimestampIfNecessary(@NonNull EntityEventContext<Object> context, boolean isUpdate) {
        RuntimePersistentProperty<Object>[] applicableProperties = this.getApplicableProperties((RuntimePersistentEntity<Object>)context.getPersistentEntity());
        Object now = this.dateTimeProvider.getNow();
        for (RuntimePersistentProperty<Object> property : applicableProperties) {
            if (isUpdate && !property.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true).booleanValue()) continue;
            BeanProperty beanProperty = property.getProperty();
            Class propertyType = property.getType();
            if (propertyType.isInstance(now)) {
                context.setProperty(beanProperty, now);
                continue;
            }
            this.conversionService.convert(now, propertyType).ifPresent(o -> context.setProperty(beanProperty, o));
        }
    }
}

