/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Internal
abstract class BaseOperations<T, Exc extends Exception> {
    protected final EntityEventListener<Object> entityEventListener;
    protected final RuntimePersistentEntity<T> persistentEntity;
    protected final ConversionService<?> conversionService;

    BaseOperations(EntityEventListener<Object> entityEventListener, RuntimePersistentEntity<T> persistentEntity, ConversionService<?> conversionService) {
        this.entityEventListener = entityEventListener;
        this.persistentEntity = persistentEntity;
        this.conversionService = conversionService;
    }

    protected void checkOptimisticLocking(long expected, long received) {
        if (received != expected) {
            throw new OptimisticLockException("Execute update returned unexpected row count. Expected: " + expected + " got: " + received);
        }
    }

    public void persist() {
        try {
            boolean vetoed = this.triggerPrePersist();
            if (vetoed) {
                return;
            }
            boolean cascades = this.persistentEntity.cascadesPersist();
            if (cascades) {
                this.cascadePre(Relation.Cascade.PERSIST);
            }
            this.execute();
            this.triggerPostPersist();
            if (cascades) {
                this.cascadePost(Relation.Cascade.PERSIST);
            }
        }
        catch (Exception e) {
            this.failed(e, "PERSIST");
        }
    }

    public void delete() {
        this.collectAutoPopulatedPreviousValues();
        boolean vetoed = this.triggerPreRemove();
        if (vetoed) {
            return;
        }
        try {
            this.execute();
            this.triggerPostRemove();
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            this.failed(e, "DELETE");
        }
    }

    public void update() {
        this.collectAutoPopulatedPreviousValues();
        boolean vetoed = this.triggerPreUpdate();
        if (vetoed) {
            return;
        }
        try {
            boolean cascades = this.persistentEntity.cascadesUpdate();
            if (cascades) {
                this.cascadePre(Relation.Cascade.UPDATE);
            }
            this.execute();
            this.triggerPostUpdate();
            if (cascades) {
                this.cascadePost(Relation.Cascade.UPDATE);
            }
        }
        catch (OptimisticLockException ex) {
            throw ex;
        }
        catch (Exception e) {
            this.failed(e, "UPDATE");
        }
    }

    protected void failed(Exception e, String operation) throws DataAccessException {
        throw new DataAccessException("Error executing " + operation + ": " + e.getMessage(), (Throwable)e);
    }

    protected abstract void cascadePre(Relation.Cascade var1);

    protected abstract void cascadePost(Relation.Cascade var1);

    protected abstract void collectAutoPopulatedPreviousValues();

    protected abstract void execute() throws Exc;

    public abstract void veto(Predicate<T> var1);

    protected T updateEntityId(BeanProperty<T, Object> identity, T entity, Object id) {
        if (id == null) {
            return entity;
        }
        if (identity.getType().isInstance(id)) {
            return this.setProperty(identity, entity, id);
        }
        return this.convertAndSetWithValue(identity, entity, id);
    }

    protected boolean triggerPrePersist() {
        if (!this.persistentEntity.hasPrePersistEventListeners()) {
            return false;
        }
        return this.triggerPre(arg_0 -> this.entityEventListener.prePersist(arg_0));
    }

    protected boolean triggerPreUpdate() {
        if (!this.persistentEntity.hasPreUpdateEventListeners()) {
            return false;
        }
        return this.triggerPre(arg_0 -> this.entityEventListener.preUpdate(arg_0));
    }

    protected boolean triggerPreRemove() {
        if (!this.persistentEntity.hasPreRemoveEventListeners()) {
            return false;
        }
        return this.triggerPre(arg_0 -> this.entityEventListener.preRemove(arg_0));
    }

    protected void triggerPostUpdate() {
        if (!this.persistentEntity.hasPostUpdateEventListeners()) {
            return;
        }
        this.triggerPost(arg_0 -> this.entityEventListener.postUpdate(arg_0));
    }

    protected void triggerPostRemove() {
        if (!this.persistentEntity.hasPostRemoveEventListeners()) {
            return;
        }
        this.triggerPost(arg_0 -> this.entityEventListener.postRemove(arg_0));
    }

    protected void triggerPostPersist() {
        if (!this.persistentEntity.hasPostPersistEventListeners()) {
            return;
        }
        this.triggerPost(arg_0 -> this.entityEventListener.postPersist(arg_0));
    }

    protected abstract boolean triggerPre(Function<EntityEventContext<Object>, Boolean> var1);

    protected abstract void triggerPost(Consumer<EntityEventContext<Object>> var1);

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    private <B, L> B convertAndSetWithValue(BeanProperty<B, L> beanProperty, B bean, L value) {
        Argument argument = beanProperty.asArgument();
        ArgumentConversionContext context = ConversionContext.of((Argument)argument);
        Object convertedValue = this.conversionService.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + beanProperty.getType()))));
        if (beanProperty.isReadOnly()) {
            return (B)beanProperty.withValue(bean, convertedValue);
        }
        beanProperty.set(bean, convertedValue);
        return bean;
    }
}

