/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.DeleteOneReactiveInterceptor;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import org.reactivestreams.Publisher;

public class DefaultDeleteOneReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements DeleteOneReactiveInterceptor<Object, Object> {
    protected DefaultDeleteOneReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 1) {
            Object o = parameterValues[0];
            if (o != null) {
                DeleteOperation<Object> batchOperation = this.getDeleteOperation(context, o);
                Publisher publisher = this.reactiveOperations.delete(batchOperation);
                return Publishers.convertPublisher((Object)publisher, (Class)context.getReturnType().getType());
            }
            throw new IllegalArgumentException("Entity to delete cannot be null");
        }
        throw new IllegalStateException("Expected exactly one argument");
    }
}

