/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.DeleteAllReactiveInterceptor;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import org.reactivestreams.Publisher;

public class DefaultDeleteAllReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements DeleteAllReactiveInterceptor<Object, Object> {
    protected DefaultDeleteAllReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Publisher publisher;
        Argument arg = context.getReturnType().asArgument();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            publisher = this.reactiveOperations.executeDelete(preparedQuery);
        } else {
            Object[] parameterValues = context.getParameterValues();
            Class<?> rootEntity = this.getRequiredRootEntity(context);
            if (parameterValues.length == 1 && parameterValues[0] instanceof Iterable) {
                DeleteBatchOperation<?> deleteBatchOperation = this.getDeleteBatchOperation(context, rootEntity, (Iterable)parameterValues[0]);
                publisher = this.reactiveOperations.deleteAll(deleteBatchOperation);
            } else if (parameterValues.length == 0) {
                DeleteBatchOperation batchOperation = this.getDeleteAllBatchOperation(context);
                publisher = this.reactiveOperations.deleteAll(batchOperation);
            } else {
                throw new IllegalArgumentException("Unexpected argument types received to deleteAll method");
            }
        }
        return Publishers.convertPublisher((Object)publisher, (Class)arg.getType());
    }
}

