/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.FindAllInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Collections;

public class DefaultFindAllInterceptor<T, R>
extends AbstractQueryInterceptor<T, Iterable<R>>
implements FindAllInterceptor<T, R> {
    protected DefaultFindAllInterceptor(RepositoryOperations datastore) {
        super(datastore);
    }

    public Iterable<R> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Iterable<R>> context) {
        Class rt = context.getReturnType().getType();
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            Iterable iterable = this.operations.findAll(preparedQuery);
            if (rt.isInstance(iterable)) {
                return iterable;
            }
            return ConversionService.SHARED.convert((Object)iterable, context.getReturnType().asArgument()).orElse(Collections.emptyList());
        }
        PagedQuery pagedQuery = this.getPagedQuery(context);
        Iterable iterable = this.operations.findAll(pagedQuery);
        if (rt.isInstance(iterable)) {
            return iterable;
        }
        return ConversionService.SHARED.convert((Object)iterable, context.getReturnType().asArgument()).orElse(Collections.emptyList());
    }
}

