/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.SaveAllReactiveInterceptor;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import org.reactivestreams.Publisher;

public class DefaultSaveAllReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements SaveAllReactiveInterceptor<Object, Object> {
    protected DefaultSaveAllReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Object[] parameterValues = context.getParameterValues();
        if (ArrayUtils.isNotEmpty((Object[])parameterValues) && parameterValues[0] instanceof Iterable) {
            BatchOperation batchOperation = this.getBatchOperation(context, (Iterable)parameterValues[0]);
            Publisher publisher = this.reactiveOperations.persistAll(batchOperation);
            return Publishers.convertPublisher((Object)publisher, (Class)context.getReturnType().getType());
        }
        throw new IllegalArgumentException("First argument should be an iterable");
    }
}

