/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.QueryResultAnalyzer;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntitySubqueryImpl;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Selection;
import java.util.function.Function;

@Internal
final class SourcePersistentEntityCriteriaQueryImpl<T>
extends AbstractPersistentEntityCriteriaQuery<T>
implements SourcePersistentEntityCriteriaQuery<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;

    SourcePersistentEntityCriteriaQueryImpl(Class<T> result, Function<ClassElement, SourcePersistentEntity> entityResolver, CriteriaBuilder criteriaBuilder) {
        this((ExpressionType<T>)new ClassExpressionType(result), entityResolver, criteriaBuilder);
    }

    SourcePersistentEntityCriteriaQueryImpl(ExpressionType<T> result, Function<ClassElement, SourcePersistentEntity> entityResolver, CriteriaBuilder criteriaBuilder) {
        super(result, criteriaBuilder);
        this.entityResolver = entityResolver;
    }

    @Override
    public <X> PersistentEntityRoot<X> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        throw new IllegalStateException("Unsupported operation");
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity, this.criteriaBuilder);
        return newEntityRoot;
    }

    @Override
    public String getQueryResultTypeName() {
        Selection selection = this.selection;
        if (selection instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            QueryResultAnalyzer selectionVisitor = new QueryResultAnalyzer();
            selectionVisitable.visitSelection((SelectionVisitor)selectionVisitor);
            return selectionVisitor.getQueryResultTypeName();
        }
        return null;
    }

    public <U> PersistentEntitySubquery<U> subquery(ExpressionType<U> type) {
        return new SourcePersistentEntitySubqueryImpl<U>((AbstractQuery<?>)this, type, this.entityResolver, this.criteriaBuilder);
    }
}

