/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaInsert;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaDelete;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterStringExpressionImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityCriteriaDeleteImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityCriteriaInsertImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityCriteriaQueryImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityCriteriaUpdateImpl;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Internal
public final class MethodMatchSourcePersistentEntityCriteriaBuilderImpl
extends AbstractCriteriaBuilder
implements SourcePersistentEntityCriteriaBuilder {
    private final Map<String, DataType> dataTypes;
    private final MethodMatchContext methodMatchContext;

    public MethodMatchSourcePersistentEntityCriteriaBuilderImpl(MethodMatchContext matchContext) {
        this.methodMatchContext = matchContext;
        this.dataTypes = Utils.getConfiguredDataTypes(matchContext.getRepositoryClass());
    }

    public PersistentEntityCriteriaQuery<Tuple> createTupleQuery() {
        return new SourcePersistentEntityCriteriaQueryImpl<Tuple>(Tuple.class, this.methodMatchContext::getEntity, (CriteriaBuilder)this);
    }

    @Override
    public SourcePersistentEntityCriteriaQuery<Object> createQuery() {
        return new SourcePersistentEntityCriteriaQueryImpl<Object>(Object.class, this.methodMatchContext::getEntity, (CriteriaBuilder)this);
    }

    @Override
    public <T> SourcePersistentEntityCriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new SourcePersistentEntityCriteriaQueryImpl<T>(resultClass, this.methodMatchContext::getEntity, (CriteriaBuilder)this);
    }

    @Override
    public <T> SourcePersistentEntityCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        return new SourcePersistentEntityCriteriaDeleteImpl<T>(this.methodMatchContext::getEntity, targetEntity, (CriteriaBuilder)this);
    }

    @Override
    public <T> SourcePersistentEntityCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new SourcePersistentEntityCriteriaUpdateImpl<T>(this.methodMatchContext::getEntity, targetEntity, (CriteriaBuilder)this);
    }

    public <T> PersistentEntityCriteriaInsert<T> createCriteriaInsert(Class<T> targetEntity) {
        return this.createCriteriaInsert((ClassElement)this.methodMatchContext.getVisitorContext().getClassElement(targetEntity).orElseThrow());
    }

    @Override
    public <T> PersistentEntityCriteriaInsert<T> createCriteriaInsert(ClassElement targetEntity) {
        return this.createCriteriaInsert(this.methodMatchContext.getEntity(targetEntity));
    }

    @Override
    public <T> PersistentEntityCriteriaInsert<T> createCriteriaInsert(SourcePersistentEntity targetEntity) {
        return new SourcePersistentEntityCriteriaInsertImpl(targetEntity, (CriteriaBuilder)this);
    }

    public ParameterExpression<Object> expression(PersistentProperty property, String expression) {
        return new SourceParameterStringExpressionImpl(property, expression);
    }

    public ParameterExpression<Object> parameter(ParameterElement parameterElement, PersistentPropertyPath propertyPath) {
        return new SourceParameterExpressionImpl(this.dataTypes, this.methodMatchContext.getParameters(), parameterElement, false, propertyPath);
    }

    public ParameterExpression<Object> parameterReferencingMethodParameter(int parameterIndex) {
        return new SourceParameterExpressionImpl(this.dataTypes, this.methodMatchContext.getParameters(), this.methodMatchContext.getParameters()[parameterIndex], false, null);
    }

    public ParameterExpression<Object> parameterReferencingMethodParameter(String parameterName) {
        ParameterElement[] parameters;
        ParameterElement parameterElement = null;
        for (ParameterElement parameter : parameters = this.methodMatchContext.getParameters()) {
            if (!parameter.stringValue(Parameter.class).orElse(parameter.getName()).equals(parameterName)) continue;
            parameterElement = parameter;
            break;
        }
        return new SourceParameterExpressionImpl(this.dataTypes, this.methodMatchContext.getParameters(), parameterElement, false, null);
    }

    public ParameterExpression<Object> entityPropertyParameter(ParameterElement entityParameter, @Nullable PersistentPropertyPath propertyPath) {
        return new SourceParameterExpressionImpl(this.dataTypes, this.methodMatchContext.getParameters(), entityParameter, true, propertyPath);
    }
}

