/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.jpa.jx;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class ConvertAnnotationMapper
implements NamedAnnotationMapper {
    public @NonNull String getName() {
        return "javax.persistence.Convert";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> convertAnnotation, VisitorContext visitorContext) {
        String converter = convertAnnotation.stringValue("converter").orElse(null);
        if (converter == null || converter.equals(Void.TYPE.getName()) || converter.equals(Object.class.getName())) {
            visitorContext.fail("Missing converter element " + converter, null);
            return Collections.emptyList();
        }
        if (convertAnnotation.stringValue("attributeName").isPresent()) {
            visitorContext.fail("@Convert value 'attributeName' not supported", null);
        }
        if (convertAnnotation.stringValue("disableConversion").isPresent()) {
            visitorContext.fail("@Convert value 'disableConversion' not supported", null);
        }
        return Collections.singletonList(AnnotationValue.builder(MappedProperty.class).member("converter", new AnnotationClassValue[]{new AnnotationClassValue(converter)}).build());
    }
}

