/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.List;

@Internal
public final class CountMethodMatcher
extends AbstractMethodMatcher {
    public CountMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "count").tryMatch(QueryMatchId.DISTINCT, "Distinct").tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").takeRest(QueryMatchId.PROJECTION).build());
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        if (TypeUtils.isValidCountReturnType(matchContext)) {
            return new QueryCriteriaMethodMatch(matches){
                boolean distinct;
                {
                    this.distinct = false;
                }

                @Override
                protected <T> void applyDistinct(PersistentEntityCriteriaQuery<T> query) {
                    this.distinct = true;
                }

                @Override
                protected <T> void applyProjections(String projectionPart, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb, String returnTypeName) {
                    if (StringUtils.isNotEmpty((CharSequence)projectionPart)) {
                        Expression<Object> propertyPath = this.getProperty(root, projectionPart);
                        Expression count = this.distinct ? cb.countDistinct(propertyPath) : cb.count(propertyPath);
                        query.multiselect(new Selection[]{count});
                    } else {
                        Expression count = this.distinct ? cb.countDistinct(root) : cb.count(root);
                        query.multiselect(new Selection[]{count});
                    }
                }

                @Override
                protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    return FindersUtils.pickCountInterceptor(matchContext, matchContext.getReturnType());
                }

                @Override
                protected DataMethod.OperationType getOperationType() {
                    return DataMethod.OperationType.COUNT;
                }
            };
        }
        return null;
    }
}

