/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

@Internal
public final class Projections {
    private static final List<Projection> PROJECTION_LIST = Arrays.stream(Projections.class.getClasses()).filter(clazz -> Projection.class.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> {
        try {
            return (Projection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }).toList();

    @Nullable
    public static Selection<?> find(@NonNull PersistentEntityRoot<?> entityRoot, @NonNull PersistentEntityCriteriaBuilder cb, String value, BiFunction<PersistentEntityRoot<?>, String, PersistentPropertyPath<?>> findFunction) {
        String decapitalized = NameUtils.decapitalize((String)value);
        Optional path = PersistentEntityUtils.getPersistentPropertyPath((PersistentEntity)entityRoot.getPersistentEntity(), (String)decapitalized);
        if (path.isPresent()) {
            return entityRoot.get((String)path.get());
        }
        for (Projection projection : PROJECTION_LIST) {
            Selection<?> selection = projection.find(entityRoot, cb, value, findFunction);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    static interface Projection {
        @Nullable
        public Selection<?> find(@NonNull PersistentEntityRoot<?> var1, @NonNull PersistentEntityCriteriaBuilder var2, @NonNull String var3, BiFunction<PersistentEntityRoot<?>, String, PersistentPropertyPath<?>> var4);
    }

    private static abstract class PrefixedPropertyProjection
    implements Projection {
        private PrefixedPropertyProjection() {
        }

        @Override
        public final Selection<?> find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, String value, BiFunction<PersistentEntityRoot<?>, String, PersistentPropertyPath<?>> findFunction) {
            String prefix = this.getPrefix();
            if (value.startsWith(prefix)) {
                String remaining = value.substring(prefix.length());
                String propertyName = NameUtils.decapitalize((String)remaining);
                PersistentPropertyPath<?> propertyPath = findFunction.apply(entityRoot, propertyName);
                if (propertyPath == null) {
                    throw new IllegalStateException("Cannot project on non-existent property " + propertyName);
                }
                return this.createProjection((CriteriaBuilder)cb, propertyPath);
            }
            return null;
        }

        public abstract Selection<?> createProjection(CriteriaBuilder var1, PersistentPropertyPath<?> var2);

        protected abstract String getPrefix();
    }

    public static class Avg
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentPropertyPath<?> propertyPath) {
            return cb.avg(propertyPath);
        }

        @Override
        protected String getPrefix() {
            return "Avg";
        }
    }

    public static class Sum
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentPropertyPath<?> propertyPath) {
            return cb.sum(propertyPath);
        }

        @Override
        protected String getPrefix() {
            return "Sum";
        }
    }

    public static class Min
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentPropertyPath<?> propertyPath) {
            return propertyPath.isNumeric() ? cb.min(propertyPath) : cb.least(propertyPath);
        }

        @Override
        protected String getPrefix() {
            return "Min";
        }
    }

    public static class Max
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentPropertyPath<?> propertyPath) {
            return propertyPath.isNumeric() ? cb.max(propertyPath) : cb.greatest(propertyPath);
        }

        @Override
        protected String getPrefix() {
            return "Max";
        }
    }
}

