/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.annotated;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Update;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.UpdateMethodMatcher;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.processing.ProcessingException;
import java.util.Arrays;
import java.util.Collections;

@Internal
public final class UpdateAnnotatedMethodMatcher
implements MethodMatcher {
    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().hasStereotype(Update.class)) {
            if (matchContext.getRootEntity() == null) {
                throw new ProcessingException((Element)matchContext.getMethodElement(), "Repository does not have a well-defined primary entity type");
            }
            ParameterElement[] parameters = matchContext.getParameters();
            ParameterElement entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
            ParameterElement entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
            if (entityParameter != null || entitiesParameter != null) {
                return UpdateMethodMatcher.entityUpdate(Collections.emptyList(), entityParameter, entitiesParameter, false);
            }
            throw new ProcessingException((Element)matchContext.getMethodElement(), "Update method should include an entity to update");
        }
        return null;
    }

    @Override
    public int getOrder() {
        return -3000;
    }
}

