/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import jakarta.persistence.criteria.Selection;
import java.util.List;

@Internal
public final class ExistsMethodMatcher
extends AbstractMethodMatcher {
    public ExistsMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "exists").tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").failOnRest("Exists method doesn't support projections").build());
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        if (TypeUtils.doesMethodProducesABoolean(matchContext.getMethodElement())) {
            return new QueryCriteriaMethodMatch(matches){

                @Override
                protected <T> void applyProjections(String projectionPart, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb, String returnTypeName) {
                    query.multiselect(new Selection[]{cb.literal((Object)true)});
                }

                @Override
                protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    return FindersUtils.pickExistsInterceptor(matchContext, matchContext.getReturnType());
                }

                @Override
                protected DataMethod.OperationType getOperationType() {
                    return DataMethod.OperationType.EXISTS;
                }
            };
        }
        return null;
    }
}

