/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.annotation.TenantId;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.annotation.WithTenantId;
import io.micronaut.data.annotation.WithoutTenantId;
import io.micronaut.data.annotation.repeatable.QueryHints;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.Projections;
import io.micronaut.data.processor.visitors.finders.Restrictions;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCriteriaMethodMatch
implements MethodMatcher.MethodMatch {
    private static final String OPERATOR_OR = "Or";
    private static final String OPERATOR_AND = "And";
    private static final String[] OPERATORS = new String[]{"And", "Or"};
    private static final String NOT = "Not";
    private static final String IGNORE_CASE = "IgnoreCase";
    private static final Map<String, Pattern> OPERATOR_PATTERNS = new TreeMap<String, Pattern>();
    private static final List<String> PROPERTY_RESTRICTIONS;
    private static final Pattern RESTRICTIONS_PATTERN;
    @Nullable
    protected final List<MethodNameParser.Match> matches;

    protected AbstractCriteriaMethodMatch(List<MethodNameParser.Match> matches) {
        this.matches = matches;
    }

    @Nullable
    protected ParameterElement getEntityParameter() {
        return null;
    }

    @Nullable
    protected ParameterElement getEntitiesParameter() {
        return null;
    }

    @NonNull
    protected abstract DataMethod.OperationType getOperationType();

    protected boolean supportedByImplicitQueries() {
        return false;
    }

    @Override
    public final MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
        boolean encodeEntityParameters;
        MethodMatchInfo methodMatchInfo;
        if (this.supportedByImplicitQueries() && matchContext.supportsImplicitQueries() && this.hasNoWhereAndJoinDeclaration(matchContext)) {
            FindersUtils.InterceptorMatch entry = this.resolveReturnTypeAndInterceptor(matchContext);
            methodMatchInfo = new MethodMatchInfo(this.getOperationType(), (TypedElement)entry.returnType(), entry.interceptor());
        } else {
            methodMatchInfo = this.build(matchContext);
        }
        ParameterElement entityParameter = this.getEntityParameter();
        ParameterElement entitiesParameter = this.getEntitiesParameter();
        ParameterElement idParameter = Arrays.stream(matchContext.getParameters()).filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
        if (idParameter != null) {
            methodMatchInfo.addParameterRole("id", idParameter.stringValue(Parameter.class).orElse(idParameter.getName()));
        }
        boolean bl = encodeEntityParameters = !DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)matchContext.getAnnotationMetadata());
        if (entityParameter != null) {
            methodMatchInfo.encodeEntityParameters(encodeEntityParameters);
            methodMatchInfo.addParameterRole("entity", entityParameter.getName());
        } else if (entitiesParameter != null) {
            methodMatchInfo.encodeEntityParameters(encodeEntityParameters);
            methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
        }
        return methodMatchInfo;
    }

    protected abstract MethodMatchInfo build(MethodMatchContext var1);

    protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
        ParameterElement entityParameter = this.getEntityParameter();
        ParameterElement entitiesParameter = this.getEntitiesParameter();
        return FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, this.getOperationType(), matchContext);
    }

    @Nullable
    protected final Predicate extractPredicates(List<ParameterElement> queryParams, PersistentEntityRoot<?> root, PersistentEntityCriteriaBuilder cb) {
        if (CollectionUtils.isNotEmpty(queryParams)) {
            PersistentEntity rootEntity = root.getPersistentEntity();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(queryParams.size());
            for (ParameterElement queryParam : queryParams) {
                String paramName = queryParam.getName();
                io.micronaut.data.model.PersistentPropertyPath propPath = rootEntity.getPropertyPath(rootEntity.getPath(paramName).orElse(paramName));
                ParameterExpression param = ((SourcePersistentEntityCriteriaBuilder)cb).parameter(queryParam, propPath);
                if (propPath == null) {
                    if ("id".equals(paramName) && (rootEntity.hasIdentity() || rootEntity.hasCompositeIdentity())) {
                        predicates.add(cb.equal((Expression)root.id(), param));
                        continue;
                    }
                    throw new MatchFailedException("Cannot query persistentEntity [" + rootEntity.getSimpleName() + "] on non-existent property: " + paramName);
                }
                PersistentProperty property = propPath.getProperty();
                if (property == rootEntity.getIdentity()) {
                    predicates.add(cb.equal((Expression)root.id(), param));
                    continue;
                }
                if (property == rootEntity.getVersion()) {
                    predicates.add(cb.equal((Expression)root.version(), param));
                    continue;
                }
                if (propPath.getAssociations().isEmpty()) {
                    predicates.add(cb.equal((Expression)root.get(property.getName()), param));
                    continue;
                }
                Association association = (Association)propPath.getAssociations().get(0);
                if (propPath.getAssociations().size() == 1 && PersistentEntityUtils.isAccessibleWithoutJoin((Association)association, (PersistentProperty)property)) {
                    predicates.add(cb.equal((Expression)root.join(association.getName()).get(property.getName()), param));
                    continue;
                }
                throw new MatchFailedException("Cannot apply a predicate to a path with an association: " + paramName);
            }
            if (predicates.isEmpty()) {
                return null;
            }
            return cb.and(predicates);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected <T> Predicate interceptPredicate(MethodMatchContext matchContext, List<ParameterElement> notConsumedParameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb, @Nullable Predicate existingPredicate) {
        Predicate tenantIdEqual;
        if (matchContext.getMethodElement().hasAnnotation(WithoutTenantId.class)) {
            return existingPredicate;
        }
        PersistentProperty tenantIdProperty = root.getPersistentEntity().getPersistentProperties().stream().filter(p -> p.getAnnotationMetadata().hasStereotype(TenantId.class)).findFirst().orElse(null);
        if (tenantIdProperty == null) return existingPredicate;
        AnnotationValue withTenantId = matchContext.getMethodElement().getAnnotation(WithTenantId.class);
        SourcePersistentEntityCriteriaBuilder scb = (SourcePersistentEntityCriteriaBuilder)cb;
        if (withTenantId != null) {
            Object value = withTenantId.getValues().get("value");
            if (value instanceof String) {
                String constant = (String)value;
                tenantIdEqual = cb.equal((Expression)root.get(tenantIdProperty), cb.literal((Object)constant));
            } else {
                if (!(value instanceof EvaluatedExpressionReference)) throw new IllegalStateException("Unrecognized tenantId annotation: " + withTenantId);
                EvaluatedExpressionReference ref = (EvaluatedExpressionReference)value;
                tenantIdEqual = cb.equal((Expression)root.get(tenantIdProperty), scb.expression(tenantIdProperty, (String)ref.annotationValue()));
            }
        } else {
            tenantIdEqual = cb.equal((Expression)root.get(tenantIdProperty), scb.expression(tenantIdProperty, "#{ctx[T(io.micronaut.data.runtime.multitenancy.TenantResolver)].resolveTenantIdentifier()}"));
        }
        if (existingPredicate == null) return tenantIdEqual;
        return cb.and((Expression)existingPredicate, (Expression)tenantIdEqual);
    }

    protected final <T> Predicate extractPredicates(String querySequence, Iterator<ParameterElement> parametersIt, PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb) {
        Predicate predicate = null;
        boolean containsOperator = false;
        if (querySequence != null) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Map.Entry<String, Pattern> operatorPatternEntry : OPERATOR_PATTERNS.entrySet()) {
                Matcher currentMatcher = operatorPatternEntry.getValue().matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                String operatorInUse = operatorPatternEntry.getKey();
                String[] queryParameters = querySequence.split(operatorInUse);
                ArrayList<Predicate> opPredicates = new ArrayList<Predicate>();
                Pattern orPattern = OPERATOR_PATTERNS.get(OPERATOR_OR);
                for (String queryParameter : queryParameters) {
                    if (!OPERATOR_OR.equals(operatorInUse) && orPattern.matcher(queryParameter).find()) {
                        opPredicates.add(this.extractPredicates(queryParameter, parametersIt, root, cb));
                        continue;
                    }
                    opPredicates.add(this.findMethodPredicate(queryParameter, root, cb, parametersIt));
                }
                if (opPredicates.isEmpty()) break;
                if (OPERATOR_OR.equals(operatorInUse)) {
                    predicates.add(cb.or(opPredicates));
                    break;
                }
                predicates.add(cb.and(opPredicates));
                break;
            }
            if (!predicates.isEmpty()) {
                predicate = cb.and(predicates);
            }
        }
        if (!containsOperator && querySequence != null) {
            predicate = this.findMethodPredicate(querySequence, root, cb, parametersIt);
        }
        return predicate;
    }

    private <T> Predicate findMethodPredicate(String expression, PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters) {
        Optional<String> optionalRestrictionName = PROPERTY_RESTRICTIONS.stream().filter(expression::endsWith).findFirst();
        if (optionalRestrictionName.isPresent()) {
            Restrictions.PropertyRestriction<Object> restriction;
            Object restrictionName = optionalRestrictionName.get();
            String propertyName = AbstractCriteriaMethodMatch.extractPropertyName(expression, (String)restrictionName);
            if (StringUtils.isEmpty((CharSequence)propertyName)) {
                throw new MatchFailedException("Missing property name for restriction: " + (String)restrictionName);
            }
            if (propertyName.endsWith(IGNORE_CASE)) {
                restrictionName = (String)restrictionName + IGNORE_CASE;
                propertyName = propertyName.substring(IGNORE_CASE.length());
            }
            if ((restriction = Restrictions.findPropertyRestriction((String)restrictionName)) == null) {
                throw new MatchFailedException("Unknown restriction: " + (String)restrictionName);
            }
            return this.getPropertyRestriction(propertyName, root, cb, parameters, restriction);
        }
        Matcher matcher = RESTRICTIONS_PATTERN.matcher(expression);
        if (matcher.find()) {
            String restrictionName = matcher.group(1);
            Restrictions.Restriction<Object> restriction = Restrictions.findRestriction(restrictionName);
            if (restriction == null) {
                throw new MatchFailedException("Unknown restriction: " + restrictionName);
            }
            return this.getRestriction(root, cb, parameters, restriction);
        }
        String propertyName = expression;
        Object restrictionName = "Equals";
        if (propertyName.endsWith(IGNORE_CASE)) {
            restrictionName = (String)restrictionName + IGNORE_CASE;
            propertyName = AbstractCriteriaMethodMatch.extractPropertyName(propertyName, IGNORE_CASE);
        }
        Restrictions.PropertyRestriction<Object> restriction = Restrictions.findPropertyRestriction((String)restrictionName);
        return this.getPropertyRestriction(propertyName, root, cb, parameters, restriction);
    }

    private static String extractPropertyName(String queryParameter, String clause) {
        int i;
        String propName = clause != null ? ((i = queryParameter.lastIndexOf(clause)) > -1 ? queryParameter.substring(0, i) : queryParameter) : queryParameter;
        return propName;
    }

    private <T> Predicate getPropertyRestriction(String propertyName, PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters, Restrictions.PropertyRestriction<Object> restriction) {
        boolean negation = false;
        if (propertyName.endsWith(NOT)) {
            int i = propertyName.lastIndexOf(NOT);
            propertyName = propertyName.substring(0, i);
            negation = true;
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            throw new MatchFailedException("No property name specified in clause: " + restriction.getName());
        }
        Expression<Object> prop = this.getProperty(root, propertyName);
        List<ParameterExpression<T>> parameterExpressions = this.provideParams(parameters, restriction.getRequiredParameters(), restriction.getName(), cb, prop);
        Predicate predicate = restriction.find(root, cb, prop, parameterExpressions);
        if (negation) {
            predicate = predicate.not();
        }
        return predicate;
    }

    private <T> Predicate getRestriction(PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters, Restrictions.Restriction<Object> restriction) {
        IExpression property = null;
        if (restriction.getName().equals("Ids")) {
            property = root.id();
        }
        List<ParameterExpression<T>> parameterExpressions = this.provideParams(parameters, restriction.getRequiredParameters(), restriction.getName(), cb, (Expression<?>)property);
        return restriction.find(root, cb, parameterExpressions);
    }

    private <T> List<ParameterExpression<T>> provideParams(Iterator<ParameterElement> parameters, int requiredParameters, String restrictionName, PersistentEntityCriteriaBuilder cb, @Nullable Expression<?> expression) {
        if (requiredParameters == 0) {
            return Collections.emptyList();
        }
        SourcePersistentEntityCriteriaBuilder scb = (SourcePersistentEntityCriteriaBuilder)cb;
        ArrayList<ParameterExpression<T>> params = new ArrayList<ParameterExpression<T>>(requiredParameters);
        for (int i = 0; i < requiredParameters; ++i) {
            if (!parameters.hasNext()) {
                throw new MatchFailedException("Insufficient arguments to method criteria: " + restrictionName);
            }
            ParameterElement parameter = parameters.next();
            ClassElement genericType = parameter.getGenericType();
            if (TypeUtils.isContainerType(genericType)) {
                genericType = genericType.getFirstTypeArgument().orElse(genericType);
            }
            if (expression instanceof PersistentPropertyPath) {
                PersistentPropertyPath pp = (PersistentPropertyPath)expression;
                io.micronaut.data.model.PersistentPropertyPath propertyPath = io.micronaut.data.model.PersistentPropertyPath.of((List)pp.getAssociations(), (PersistentProperty)pp.getProperty());
                if (!this.isValidType(genericType, (SourcePersistentProperty)propertyPath.getProperty())) {
                    SourcePersistentProperty property = (SourcePersistentProperty)propertyPath.getProperty();
                    throw new IllegalArgumentException("Parameter [" + genericType.getType().getName() + " " + parameter.getName() + "] is not compatible with property [" + property.getType().getName() + " " + property.getName() + "] of entity: " + property.getOwner().getName());
                }
                params.add(scb.parameter(parameter, propertyPath));
                continue;
            }
            params.add(scb.parameter(parameter, null));
        }
        return params;
    }

    private boolean isValidType(ClassElement genericType, SourcePersistentProperty property) {
        ClassElement genericPropertyType;
        if (TypeUtils.isObjectClass(genericType)) {
            return true;
        }
        PersistentEntity owner = property.getOwner();
        if (TypeUtils.areTypesCompatible(genericType, property.getType()) && !TypeUtils.isObjectClass(genericType)) {
            return true;
        }
        if (TypeUtils.isContainerType(property.getType()) && TypeUtils.areTypesCompatible(genericType, genericPropertyType = property.getType().getFirstTypeArgument().orElse(property.getType())) && !TypeUtils.isObjectClass(genericType)) {
            return true;
        }
        if (owner.hasCompositeIdentity() && property.getOwner().getCompositeIdentity()[0].equals(property)) {
            return true;
        }
        return genericType.isAssignable(Iterable.class);
    }

    @NonNull
    protected final <T> Expression<Object> getProperty(PersistentEntityRoot<T> root, String propertyName) {
        if ("id".equals(NameUtils.decapitalize((String)propertyName)) && (root.getPersistentEntity().hasIdentity() || root.getPersistentEntity().hasCompositeIdentity())) {
            return root.id();
        }
        PersistentPropertyPath<Object> property = this.findProperty(root, propertyName);
        if (property != null) {
            return property;
        }
        throw new MatchFailedException("Cannot query entity [" + root.getPersistentEntity().getSimpleName() + "] on non-existent property: " + propertyName);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected final <T> PersistentPropertyPath<Object> findProperty(PersistentEntityRoot<T> root, String propertyName) {
        void var7_10;
        Association association2;
        io.micronaut.data.model.PersistentPropertyPath pp;
        propertyName = NameUtils.decapitalize((String)propertyName);
        PersistentEntity entity = root.getPersistentEntity();
        PersistentProperty prop = entity.getPropertyByName(propertyName);
        if (prop == null) {
            Optional propertyPath = PersistentEntityUtils.getPersistentPropertyPath((PersistentEntity)entity, (String)propertyName);
            if (!propertyPath.isPresent()) return null;
            String string = (String)propertyPath.get();
            pp = entity.getPropertyPath(string);
            if (pp == null) {
                return null;
            }
        } else {
            pp = io.micronaut.data.model.PersistentPropertyPath.of(Collections.emptyList(), (PersistentProperty)prop, (String)propertyName);
        }
        PersistentEntityJoin path = root;
        for (Association association2 : pp.getAssociations()) {
            path = path.join(association2.getName());
        }
        PersistentProperty persistentProperty = pp.getProperty();
        if (persistentProperty instanceof Association && (association2 = (Association)persistentProperty).getKind() != Relation.Kind.EMBEDDED) {
            PersistentEntityJoin persistentEntityJoin = path.join(pp.getProperty().getName());
            return CriteriaUtils.requireProperty((Expression)var7_10);
        } else {
            PersistentPropertyPath persistentPropertyPath = path.get(pp.getProperty().getName());
        }
        return CriteriaUtils.requireProperty((Expression)var7_10);
    }

    protected final void applyJoinSpecs(PersistentEntityRoot<?> root, @NonNull List<AnnotationValue<Join>> joinSpecs) {
        for (AnnotationValue<Join> joinSpec : joinSpecs) {
            String path = joinSpec.stringValue().orElse(null);
            Join.Type type = joinSpec.enumValue("type", Join.Type.class).orElse(Join.Type.FETCH);
            String alias = joinSpec.stringValue("alias").orElse(null);
            if (path == null) continue;
            io.micronaut.data.model.PersistentPropertyPath propertyPath = root.getPersistentEntity().getPropertyPath(path);
            if (propertyPath == null || !(propertyPath.getProperty() instanceof Association)) {
                throw new MatchFailedException("Invalid join spec [" + path + "]. Property is not an association!");
            }
            PersistentEntityJoin p = root;
            for (Association association : propertyPath.getAssociations()) {
                p = p.join(association.getName(), type);
            }
            if (alias != null) {
                p.join(propertyPath.getProperty().getName(), type, alias);
                continue;
            }
            p.join(propertyPath.getProperty().getName(), type);
        }
    }

    @NonNull
    protected final List<AnnotationValue<Join>> joinSpecsAtMatchContext(@NonNull MethodMatchContext matchContext, boolean isQuery) {
        if (!isQuery) {
            return matchContext.getAnnotationMetadata().getDeclaredAnnotationValuesByType(Join.class);
        }
        List joins = matchContext.getAnnotationMetadata().getAnnotationValuesByType(Join.class);
        if (!joins.isEmpty()) {
            return joins;
        }
        return matchContext.getRepositoryClass().getAnnotationMetadata().getAnnotationValuesByType(Join.class);
    }

    protected final boolean hasNoWhereAndJoinDeclaration(@NonNull MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().hasAnnotation(Join.class)) {
            return false;
        }
        AnnotationMetadataHierarchy metadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass(), matchContext.getMethodElement()});
        if (metadataHierarchy.hasAnnotation("io.micronaut.data.jpa.annotation.EntityGraph")) {
            return false;
        }
        if (metadataHierarchy.hasAnnotation(QueryHint.class) || metadataHierarchy.hasAnnotation(QueryHints.class)) {
            return false;
        }
        boolean repositoryHasWhere = metadataHierarchy.hasAnnotation(Where.class);
        boolean entityHasWhere = matchContext.getRootEntity().hasAnnotation(Where.class);
        return !repositoryHasWhere && !entityHasWhere;
    }

    protected <T> List<Selection<?>> findSelections(String projectionPart, PersistentEntityRoot<T> root, PersistentEntityCriteriaBuilder cb, @Nullable String returnTypeName) {
        if (StringUtils.isEmpty((CharSequence)projectionPart)) {
            return Collections.emptyList();
        }
        ArrayList selectionList = new ArrayList();
        for (String projection : projectionPart.split(OPERATOR_AND)) {
            PersistentPropertyPath<Object> propertyPath = this.findProperty(root, projection);
            if (propertyPath != null) {
                selectionList.add((Selection<?>)propertyPath);
                continue;
            }
            Selection<?> selection = Projections.find(root, cb, projection, this::findProperty);
            if (selection != null) {
                selectionList.add(selection);
                continue;
            }
            if (projection.equals(returnTypeName)) continue;
            throw new MatchFailedException("Cannot project on non-existent property: " + NameUtils.decapitalize((String)projection));
        }
        return selectionList;
    }

    protected final MethodResult analyzeMethodResult(MethodMatchContext matchContext, String selectedType, ClassElement queryResultType, FindersUtils.InterceptorMatch interceptorMatch, boolean allowEntityResultByDefault) {
        if (selectedType != null) {
            queryResultType = matchContext.getVisitorContext().getClassElement(selectedType).or(() -> {
                try {
                    return Optional.of(PrimitiveElement.valueOf((String)selectedType));
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }).orElse(queryResultType);
        }
        return this.analyzeMethodResult(matchContext, queryResultType, interceptorMatch, allowEntityResultByDefault);
    }

    protected final MethodResult analyzeMethodResult(MethodMatchContext matchContext, ClassElement queryResultType, FindersUtils.InterceptorMatch interceptorMatch, boolean allowEntityResultByDefault) {
        boolean isDto;
        ClassElement resultType = interceptorMatch.returnType();
        boolean isRuntimeDto = false;
        boolean bl = isDto = resultType != null && !TypeUtils.areTypesCompatible(resultType, queryResultType) && (this.isDtoType(matchContext.getRepositoryClass(), resultType) || resultType.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class));
        if (isDto) {
            isRuntimeDto = this.isDtoType(matchContext.getRepositoryClass(), resultType);
        } else if (interceptorMatch.validateReturnType() && queryResultType != null && (resultType == null || !this.isVoid(resultType))) {
            if (resultType == null || TypeUtils.areTypesCompatible(resultType, queryResultType)) {
                if (!queryResultType.isPrimitive() || resultType == null) {
                    resultType = queryResultType;
                }
            } else if (!allowEntityResultByDefault || !matchContext.getRootEntity().getClassElement().equals(resultType)) {
                throw new MatchFailedException("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + resultType.getName());
            }
        }
        return new MethodResult(resultType, isDto, isRuntimeDto);
    }

    private boolean isVoid(ClassElement resultType) {
        return resultType.isAssignable(Void.TYPE) || resultType.isAssignable(Void.class) || resultType.getName().equals("kotlin.Unit");
    }

    private boolean isDtoType(ClassElement repositoryElement, ClassElement classElement) {
        return Arrays.stream(repositoryElement.stringValues(RepositoryConfiguration.class, "queryDtoTypes")).anyMatch(type -> classElement.getName().equals(type));
    }

    protected List<SourcePersistentProperty> getDtoProjectionProperties(SourcePersistentEntity entity, ClassElement returnType) {
        return returnType.getBeanProperties().stream().filter(dtoProperty -> {
            String propertyName = dtoProperty.getName();
            return !"metaClass".equals(propertyName) || !dtoProperty.getType().isAssignable("groovy.lang.MetaClass");
        }).map(dtoProperty -> {
            String propertyName = dtoProperty.getName();
            if ("metaClass".equals(propertyName) && dtoProperty.getType().isAssignable("groovy.lang.MetaClass")) {
                return null;
            }
            SourcePersistentProperty pp = entity.getPropertyByName(propertyName);
            if (pp == null) {
                pp = entity.getIdOrVersionPropertyByName(propertyName);
            }
            if (pp == null) {
                throw new MatchFailedException("Property " + propertyName + " is not present in entity: " + entity.getName());
            }
            ClassElement dtoPropertyType = dtoProperty.getType();
            if (dtoPropertyType.getName().equals("java.lang.Object") || dtoPropertyType.getName().equals("java.lang.String")) {
                return pp;
            }
            if (!TypeUtils.areTypesCompatible(dtoPropertyType, pp.getType())) {
                throw new MatchFailedException("Property [" + propertyName + "] of type [" + dtoPropertyType.getName() + "] is not compatible with equivalent property of type [" + pp.getType().getName() + "] declared in entity: " + entity.getName());
            }
            return pp;
        }).toList();
    }

    static {
        for (String operator : OPERATORS) {
            OPERATOR_PATTERNS.put(operator, Pattern.compile("(\\w+)(" + operator + ")(\\p{Upper})(\\w+)"));
        }
        PROPERTY_RESTRICTIONS = Restrictions.PROPERTY_RESTRICTIONS_MAP.keySet().stream().sorted(Comparator.comparingInt(String::length).thenComparing(String.CASE_INSENSITIVE_ORDER).reversed()).toList();
        ArrayList<String> restrictionElements = new ArrayList<String>(Restrictions.RESTRICTIONS_MAP.keySet());
        restrictionElements.sort(Comparator.comparingInt(String::length).thenComparing(String.CASE_INSENSITIVE_ORDER).reversed());
        String rExpressionPattern = String.join((CharSequence)"|", restrictionElements);
        RESTRICTIONS_PATTERN = Pattern.compile("^(" + rExpressionPattern + ")$");
    }

    protected record MethodResult(ClassElement resultType, boolean isDto, boolean isRuntimeDtoConversion) {
    }
}

